% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiopacity.R
\name{addOpacityControls}
\alias{addOpacityControls}
\title{Add Opacity Controls}
\usage{
addOpacityControls(
  map,
  layerId = NULL,
  category = NULL,
  group = NULL,
  collapsed = FALSE,
  position = c("topright", "topleft", "bottomright", "bottomleft"),
  title = NULL,
  renderOnLayerAdd = FALSE
)
}
\arguments{
\item{map}{The map to add the opacity controls to.}

\item{layerId}{One or more layer IDs to render opacity controls to.}

\item{category}{One or more categories to render opacity controls to.
Tested categories are "tile" (base layers), "image"
(e.g. raster) and "marker".}

\item{group}{One or more groups to render opacity controls to.}

\item{collapsed}{If FALSE (the default), the opacity control will always appear
in its expanded state. Set to TRUE to have the opacity control
rendered as an icon that expands when hovered over.}

\item{position}{Position of control: "topleft", "topright", "bottomleft", or "bottomright".}

\item{title}{The control title.}

\item{renderOnLayerAdd}{When this argument is TRUE, the controls will only appear when a new
layer is added and rendered in the map. This can be useful if you plan
to use 'leafletProxy()' and need the controls to be dinamically updated.}
}
\description{
Add opacity controls to leaflet map. It is possible to choose which layers will
have an opacity slider control by passing one of the arguments "category", "group"
or "layerId" (passing more than one of these arguments will cause the others to
be ignored). It is possible to pass one or more of each layerIds, categories or
groups. If you leave these arguments with the default value (NULL), the opacity
controls will be created to every layer in the map.
}
\examples{
# Load libraries
library(leaflet)
library(leaflet.multiopacity)
library(raster)

# Create raster example
r <- raster(xmn = -2.8, xmx = -2.79,
            ymn = 54.04, ymx = 54.05,
            nrows = 30, ncols = 30)
values(r) <- matrix(1:900, nrow(r), ncol(r), byrow = TRUE)
crs(r) <- crs("+init=epsg:4326")

# Provide layerId, group or category to show opacity controls
# If not specified, will render controls for all layers
# Example using layerId
leaflet() \%>\%
  addProviderTiles("Wikimedia", layerId = "Wikimedia") \%>\%
  addRasterImage(r, layerId = "raster") \%>\%
  addAwesomeMarkers(lng = -2.79545, lat = 54.04321,
                    layerId = "hospital", label = "Hospital") \%>\%
  addOpacityControls(layerId = c("raster", "hospital"))

# Example using category
leaflet() \%>\%
  addProviderTiles("Wikimedia", layerId = "Wikimedia") \%>\%
  addRasterImage(r, layerId = "raster") \%>\%
  addAwesomeMarkers(lng = -2.79545, lat = 54.04321,
                    layerId = "hospital", label = "Hospital") \%>\%
  addOpacityControls(category = c("image", "marker"))

}
