% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buildings.R
\name{setBuildingStyle}
\alias{setBuildingStyle}
\title{Update the OSM-Buildings Style}
\usage{
setBuildingStyle(
  map,
  style = list(color = "#ffcc00", wallColor = "#ffcc00", roofColor = "orange", shadows =
    TRUE)
)
}
\arguments{
\item{map}{A map widget object created from \code{\link[leaflet]{leaflet}}.}

\item{style}{A named list of styles}
}
\description{
Update the OSM-Buildings Style
}
\examples{
library(leaflet)
library(leaflet.extras2)

style <- list(color = "#0000ff", wallColor = "gray", roofColor = "orange", shadows = TRUE)
leaflet() \%>\%
  addTiles() \%>\%
  addBuildings() \%>\%
  setBuildingStyle(style) \%>\%
  setView(13.40, 52.51836, 15)
}
\seealso{
Other OSM-Buildings Plugin: 
\code{\link{addBuildings}()},
\code{\link{setBuildingData}()},
\code{\link{updateBuildingTime}()}
}
\concept{OSM-Buildings Plugin}
