% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imageMapLayers.R
\name{imageMapLayerOptions}
\alias{imageMapLayerOptions}
\title{Options for image map layer.}
\usage{
imageMapLayerOptions(format = "jpgpng", f = "json", opacity = 1,
  position = "front", maxZoom = NULL, minZoom = NULL, from = NULL,
  to = NULL, bandIds = NULL, noData = NULL, noDataInterpretation = NULL,
  pixelType = NULL, renderingRule = NULL, mosaicRule = NULL,
  token = NULL, proxy = NULL, useCors = TRUE, ...)
}
\arguments{
\item{format}{Output format of the image.}

\item{f}{Server response content type.}

\item{opacity}{Opacity of the layer. Should be a value between 0 and 1.}

\item{position}{Position of the layer relative to other overlays.}

\item{maxZoom}{Closest zoom level the layer will be displayed on the map.}

\item{minZoom}{Furthest zoom level the layer will be displayed on the map.}

\item{from}{Date    When paired with to defines the time range of data to display.
Requires the Image Layer to be time enabled.}

\item{to}{Date    When paired with from defines the time range of data to display.
Requires the Image Layer to be time enabled.}

\item{bandIds}{If there are multiple bands, you can specify which bands to export.}

\item{noData}{The pixel value representing no information.}

\item{noDataInterpretation}{Interpretation of the noData setting.}

\item{pixelType}{Leave pixelType as unspecified, or UNKNOWN, in most exportImage use cases,
unless such pixelType is desired.
Possible values: C128, C64, F32, F64, S16, S32, S8, U1, U16, U2, U32, U4, U8, UNKNOWN.}

\item{renderingRule}{A JSON representation of a \href{http://resources.arcgis.com/en/help/arcgis-rest-api/#/Raster_function_objects/02r3000000rv000000/}{raster function}}

\item{mosaicRule}{A JSON representation of a \href{http://resources.arcgis.com/en/help/arcgis-rest-api/#/Mosaic_rule_objects/02r3000000s4000000/}{mosaic rule}}

\item{token}{If you pass a token in your options it will be included in all requests to the service.}

\item{proxy}{URL of an \href{https://developers.arcgis.com/javascript/jshelp/ags_proxy.html}{ArcGIS API for JavaScript proxy} or \href{https://github.com/Esri/resource-proxy}{ArcGIS Resource Proxy} to use for proxying requests.}

\item{useCors}{If this service should use CORS when making GET requests.}

\item{...}{extra options}
}
\description{
Options for image map layer.
}
