% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tiledMapLayers.R
\name{addEsriTiledMapLayer}
\alias{addEsriTiledMapLayer}
\title{Access tiles from ArcGIS Online and ArcGIS Server to visualize and identify features.}
\usage{
addEsriTiledMapLayer(map, url, options = tiledMapLayerOptions(),
  layerId = NULL, group = NULL)
}
\arguments{
\item{map}{The leaflet map}

\item{url}{URL of the \href{http://resources.arcgis.com/en/help/arcgis-rest-api/#/Map_Service/02r3000000w2000000}{Map Service} with a tile cache.}

\item{options}{options for the tiledmap layer.}

\item{layerId}{A unique ID for the layer.}

\item{group}{The name of the group this layer should be added to.}
}
\description{
If you have published a Feature Service in ArcGIS Online, it can be used to create a static set of tiles as well. You can find details about that process in the \href{http://doc.arcgis.com/en/arcgis-online/share-maps/publish-tiles.htm#ESRI_SECTION1_F68FCBD33BD54117B23232D41A762E89}{ArcGIS Online Help}.
Your map service must be published using the Web Mercator Auxiliary Sphere tiling scheme (WKID 102100/3857) and the default scale options used by Google Maps, Bing Maps and \href{http://resources.arcgis.com/en/help/arcgisonline-content/index.html#//011q00000002000000}{ArcGIS Online}. Esri Leaflet will not support any other spatial reference for tile layers.
}
