% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{GetGldFromMoments}
\alias{GetGldFromMoments}
\title{Gets the GLD-FKML Parameters from the moments}
\usage{
GetGldFromMoments(
  mean = 0,
  variance = 1,
  skewness = 0,
  excessKurtosis = 0,
  type = 0L,
  start = NULL,
  nelderMeadOptions = NULL,
  printMsg = FALSE
)
}
\arguments{
\item{mean}{(double) mean of the distribution.}

\item{variance}{(double) variance of the distribution.}

\item{skewness}{(double) skewness of the distribution.}

\item{excessKurtosis}{(double) excess kurtosis of the distribution.}

\item{type}{(int) The type of the distribution.}

\item{start}{(numeric vector, length=2) starting value for L3 and L4. Use null for c(0,0).}

\item{nelderMeadOptions}{(list) The optimization parameters. Use null for default.}

\item{printMsg}{(bool) If \code{TRUE}, details are printed.}
}
\value{
a vector with the parameters of the GLD distribution.
}
\description{
Calculates the parameters of the generalized lambda distribution (FKML), given the first four moments of the distribution.
}
\details{
The type of the distribution is determined by one or two restrictions:
\itemize{
\item \strong{type 0:} general
\item \strong{type 1:} symmetric 'type 0'
\item \strong{type 2:} uni-modal continuous tail: L3<1 & L4<1
\item \strong{type 3:} symmetric 'type 2' L3==L4
\item \strong{type 4:} uni-modal continuous tail finite slope  L3<=0.5 &  L4<=5
\item \strong{type 5:} symmetric 'type 4' L3==L4
\item \strong{type 6:} uni-modal truncated density curves: L3>=2 & L4>=2 (includes uniform distribution)
\item \strong{type 7:} symmetric 'type 6' L3==L4
\item \strong{type 8:} S shaped L3>2 & 1<L4<2 or 1<L3<2 & L4>2
\item \strong{type 9:} U shaped 1<L3<=2 and 1<L4<=2
\item \strong{type 10:} symmetric 'type 9' L4==L4
\item \strong{type 11:} monotone L3>1 & L4<=1
}
}
\examples{
res = GetGldFromMoments(0,1,0,0,0,c(0,0))
}
