% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LDS_reconstruction.R
\name{LDS_reconstruction}
\alias{LDS_reconstruction}
\title{Learn LDS model.}
\usage{
LDS_reconstruction(
  Qa,
  u,
  v,
  start.year,
  method = "EM",
  transform = "log",
  init = NULL,
  num.restarts = 50,
  return.init = FALSE,
  ub = NULL,
  lb = NULL,
  num.islands = 4,
  pop.per.island = 250,
  niter = 1000,
  tol = 1e-05,
  return.raw = FALSE
)
}
\arguments{
\item{Qa}{Observations: a data.frame of annual streamflow with at least two columns: year and Qa.}

\item{u}{Input matrix for a single-model reconstruction, or a list of input matrices for an ensemble reconstruction.}

\item{v}{Same as u.}

\item{start.year}{Starting year of the climate proxies, i.e, the first year of the paleo period. \code{start.year + nrow(pc) - 1} will determine the last year of the study horizon, which must be greater than or equal to the last year in \code{Qa}.}

\item{method}{By default this is "EM". There are experimental methods but you should not try.}

\item{transform}{Flow transformation, either "log", "boxcox" or "none". Note that if the Box-Cox transform is used, the confidence interval after back-transformation is simply the back-transform of the trained onfidence interval; this is hackish and not entirely accurate.}

\item{init}{A list, each element is a vector of initial values for the parameters. If \code{NULL}, will be created by \code{make_init()}. See \link{make_init} for details.}

\item{num.restarts}{The number of initial conditions to start the EM search; ignored if \code{init} is provided.}

\item{return.init}{If \code{TRUE}, the list of initial values (\code{init}) will be returned. This can be useful if you want to reproduce the model from this one set of initial values.}

\item{ub}{Upper bounds, a vector whose length is the number of parameters}

\item{lb}{Lower bounds}

\item{num.islands}{Number of islands (if method is GA; experimental)}

\item{pop.per.island}{Initial population per island (if method is GA; experimental)}

\item{niter}{Maximum number of iterations, default 1000}

\item{tol}{Tolerance for likelihood convergence, default 1e-5. Note that the log-likelihood is normalized by dividing by the number of observations.}

\item{return.raw}{If TRUE, state and streamflow estimates without measurement updates will be returned.}
}
\value{
A list of the following elements
\itemize{
\item rec: reconstruction results, a data.table with the following columns
\itemize{
\item year: calculated from Qa and the length of u
\item X: the estimated hidden state
\item Xl, Xu: lower and upper range for the 95\\% confidence interval of X
\item Q: the reconstructed streamflow
\item Ql, Qu: lower and upper range for the 95\\% confidence interval of Q
}
\item theta: model parameters
\item lik: maximum likelihood
\item init: the initial condition that resulted in the maximum likelihood (if \code{return.init = TRUE}).
}
}
\description{
The initial conditions can either be randomized (specifiled by num.restarts) or provided beforehand.
}
\examples{
# Make a shorter time horizon so that this example runs fast
u <- v <- t(NPpc[601:813])
# We run this example without parallelism
foreach::registerDoSEQ()
LDS_reconstruction(NPannual, u, v, start.year = 1800, num.restarts = 1)
# Please refer to the vignette for the full run with parallel options. It takes a second or two.
}
