% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{FindTopicsNumber_plot}
\alias{FindTopicsNumber_plot}
\title{FindTopicsNumber_plot}
\usage{
FindTopicsNumber_plot(values)
}
\arguments{
\item{values}{Data-frame with first column named `topics` and other columns
are values of metrics.}
}
\description{
Support function to analyze optimal topic number. Use output of the
\code{\link{FindTopicsNumber}} function.
}
\examples{
\dontrun{

library(topicmodels)
data("AssociatedPress", package="topicmodels")
dtm <- AssociatedPress[1:10, ]
optimal.topics <- FindTopicsNumber(dtm, topics = 2:10,
  metrics = c("Arun2010", "CaoJuan2009", "Griffiths2004")
)
FindTopicsNumber_plot(optimal.topics)
}

}

