% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{.calc_subject_balance_divergence}
\alias{.calc_subject_balance_divergence}
\title{Characterizes closeness of actual group sizes to what is expected.}
\usage{
.calc_subject_balance_divergence(table_condition, props)
}
\arguments{
\item{table_condition}{The number of different condition values,
usually created by calling table(condition).}

\item{props}{Either the desired proportions (percentage) of the
sample for each condition as a named vector,
or the names of the conditions
for which we prefer to preserve the subjects,
in decreasing order of preference. If not specified, the
(full) sample proportions are used.
This is preferred among configurations with the same
taken into account by the other methods to some extent.
For example, c(A = 0.4, B = 0.4, C = 0.2) means that
we would like the number of subjects in groups A, B, and
C to be around 40\%, 40\%, and 20\% of the total number of
subjects, respectively. Whereas c("A", "B", "C") means
that if possible, we would like to keep all subjects
in group A, and prefer keeping subjects in B, even if
it results in losing more subjects from C.}
}
\value{
KL divergence of the actual group size proportions from the expected ones.
}
\description{
Characterizes closeness of actual group sizes to what is expected.
}
\seealso{
\code{\link{match_groups}} for meaning of condition parameter.
}
\keyword{internal}
