% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluation.R
\name{calc_metrics}
\alias{calc_metrics}
\title{Calculates basic metrics about ldamatch search result.}
\usage{
calc_metrics(
  is.in,
  condition,
  covariates,
  halting_test,
  props = prop.table(table(condition)),
  tiebreaker = NULL
)
}
\arguments{
\item{is.in}{The output of \code{\link{match_groups}()}:
either a logical vector, or a list of those.}

\item{condition}{A factor vector containing condition labels.}

\item{covariates}{A columnwise matrix containing
covariates to match the conditions on.}

\item{halting_test}{A function to apply to `covariates` (in matrix form)
which is TRUE iff the conditions are matched.
Signature: halting_test(condition, covariates, thresh).
The following halting tests are part of this package:
\code{\link{t_halt}}, \code{\link{U_halt}},
\code{\link{l_halt}}, \code{\link{ad_halt}},
\code{\link{ks_halt}}, \code{\link{wilks_halt}},
\code{\link{f_halt}}.
You can create the intersection of two or more halting
tests using \code{\link{create_halting_test}}.}

\item{props}{Either the desired proportions (percentage) of the
sample for each condition as a named vector,
or the names of the conditions
for which we prefer to preserve the subjects,
in decreasing order of preference. If not specified, the
(full) sample proportions are used.
This is preferred among configurations with the same
taken into account by the other methods to some extent.
For example, c(A = 0.4, B = 0.4, C = 0.2) means that
we would like the number of subjects in groups A, B, and
C to be around 40\%, 40\%, and 20\% of the total number of
subjects, respectively. Whereas c("A", "B", "C") means
that if possible, we would like to keep all subjects
in group A, and prefer keeping subjects in B, even if
it results in losing more subjects from C.}

\item{tiebreaker}{NULL, or a function similar to halting_test, used to
decide between cases for which halting_test yields
equal values.}
}
\value{
A list containing: \describe{
\item{all.is.in}{all results as a list;}
\item{is.in}{simply the first item in all.is.in or the error contained
in is.in if there was an error running \code{\link{match_groups}};}
\item{num_excluded}{the number of excluded subjects;}
\item{p_matched}{the test statistic from halting_test for the matched groups;}
\item{p_tiebreaker}{the test statistic from tiebreaker for the matched groups; and}
\item{balance_divergence}{a value characterizing the deviation
  from the expected group size proportions specified in props.}
}
If the value for a field cannot be calculated, it will still be present
with a value of NA.
}
\description{
Calculates basic metrics about ldamatch search result.
}
