% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getTopics.R
\name{getTopics}
\alias{getTopics}
\alias{getAssignments}
\alias{getDocument_sums}
\alias{getDocument_expects}
\alias{getLog.likelihoods}
\alias{getParam}
\alias{getK}
\alias{getAlpha}
\alias{getEta}
\alias{getNum.iterations}
\alias{getEstimators}
\title{Getter for LDA}
\usage{
getTopics(x)

getAssignments(x)

getDocument_sums(x)

getDocument_expects(x)

getLog.likelihoods(x)

getParam(x)

getK(x)

getAlpha(x)

getEta(x)

getNum.iterations(x)

getEstimators(x)
}
\arguments{
\item{x}{[\code{named list}]\cr
\code{\link{LDA}} object.}
}
\description{
Returns the corresponding element of a \code{\link{LDA}} object.
\code{getEstimators} computes the estimators for \code{phi} and \code{theta}.
}
\details{
The estimators for \code{phi} and \code{theta} in
\deqn{w_n^{(m)} \mid T_n^{(m)}, \bm\phi_k  \sim \textsf{Discrete}(\bm\phi_k),}
\deqn{\bm\phi_k  \sim \textsf{Dirichlet}(\eta),}
\deqn{T_n^{(m)} \mid \bm\theta_m  \sim \textsf{Discrete}(\bm\theta_m),}
\deqn{\bm\theta_m  \sim \textsf{Dirichlet}(\alpha)}
are calculated referring to Griffiths and Steyvers (2004) by
\deqn{\hat{\phi}_{k, v} = \frac{n_k^{(v)} + \eta}{n_k + V \eta},}
\deqn{\hat{\theta}_{m, k} = \frac{n_k^{(m)} + \alpha}{N^{(m)} + K \alpha}}
with \eqn{V} is the vocabulary size, \eqn{K} is the number of modeled topics;
\eqn{n_k^{(v)}} is the count of assignments of the \eqn{v}-th word to
the \eqn{k}-th topic. Analogously, \eqn{n_k^{(m)}} is the count of assignments
of the \eqn{m}-th text to the \eqn{k}-th topic. \eqn{N^{(m)}} is the total
number of assigned tokens in text \eqn{m} and \eqn{n_k} the total number of
assigned tokens to topic \eqn{k}.
}
\references{
Griffiths, Thomas L. and Steyvers, Mark (2004). "Finding scientific topics".
In: \emph{Proceedings of the National Academy of Sciences} 101 (suppl 1), p.5228--5235,
DOI 10.1073/pnas.0307752101, URL \url{http://www.pnas.org/content/101/suppl_1/5228}
}
\seealso{
Other getter functions: 
\code{\link{getJob}()},
\code{\link{getSCLOP}()},
\code{\link{getSimilarity}()}

Other LDA functions: 
\code{\link{LDABatch}()},
\code{\link{LDARep}()},
\code{\link{LDA}()}
}
\concept{LDA functions}
\concept{getter functions}
