% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_lcsm.R
\name{fit_uni_lcsm}
\alias{fit_uni_lcsm}
\title{Fit univariate latent change score models}
\usage{
fit_uni_lcsm(
  data,
  var,
  model,
  mimic = "Mplus",
  estimator = "MLR",
  missing = "FIML",
  return_lavaan_syntax = FALSE,
  ...
)
}
\arguments{
\item{data}{A data frame in "wide" format, i.e. one column for each measurement point and one row for each observation.}

\item{var}{Vector, specifying the variable names of each measurement point sequentially.}

\item{model}{List of model specifications (logical) for variables specified in \code{var}.
\itemize{
\item{\code{alpha_constant}}{ (Constant change factor)},
\item{\code{alpha_piecewise}}{ (Piecewise constant change factors)},
\item{\code{alpha_piecewise_num}}{ (Changepoint of piecewise constant change factors},
\item{\code{alpha_linear}}{ (Linear change factor)},
\item{\code{beta}}{ (Proportional change factor)},
\item{\code{phi}}{ (Autoregression of change scores)}.
}}

\item{mimic}{See \link[lavaan]{lavaan}.}

\item{estimator}{See \link[lavaan]{lavaan}.}

\item{missing}{See \link[lavaan]{lavaan}.}

\item{return_lavaan_syntax}{Logical, if TRUE return the lavaan syntax used for simulating data. To make it look beautiful use the function \link[base]{cat}.}

\item{...}{Additional arguments to be passed to \link[lavaan]{lavaan}.}
}
\value{
This function returns a lavaan class object.
}
\description{
Fit univariate latent change score models.
}
\examples{
# Fit univariate latent change score model
fit_uni_lcsm(data = data_uni_lcsm, 
             var = names(data_uni_lcsm)[2:4],
             model = list(alpha_constant = TRUE, 
                          beta = FALSE, 
                          phi = FALSE))
}
\references{
Ghisletta, P., & McArdle, J. J. (2012). Latent Curve Models and Latent Change Score Models Estimated in R. Structural Equation Modeling: A Multidisciplinary Journal, 19(4), 651–682. \url{https://doi.org/10.1080/10705511.2012.713275}.

Grimm, K. J., Ram, N., & Estabrook, R. (2017). Growth Modeling—Structural Equation and Multilevel Modeling Approaches. New York: The Guilford Press.

McArdle, J. J. (2009). Latent variable modeling of differences and changes with longitudinal data. Annual Review of Psychology, 60(1), 577–605. \url{https://doi.org/10.1146/annurev.psych.60.110707.163612}.

Yves Rosseel (2012). lavaan: An R Package for Structural Equation Modeling. Journal of Statistical Software, 48(2), 1-36.
\url{http://www.jstatsoft.org/v48/i02/}.
}
