% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/liouville_extreme.R
\name{hbvevdliouv}
\alias{hbvevdliouv}
\title{Bivariate spectral density of the CDA of survival copula and copula of Liouville vectors}
\usage{
hbvevdliouv(w, alpha, rho, CDA = c("C", "S"), useR = F)
}
\arguments{
\item{w}{vector of points at which to evaluate. Must be in the unit interval}

\item{alpha}{vector of Dirichlet allocations (must be a vector of integers if \code{CDA="C"}), otherwise strictly positive.}

\item{rho}{parameter of limiting model corresponding to index of regular variation, between \eqn{(0,1)}}

\item{CDA}{copula domain of attraction of either Liouville copula, \code{C}, or its survival copula \code{S}}

\item{useR}{whether to use the R code for the spectral density of \code{C}. Default to \code{F}. Implemented for compatibility reason.}
}
\value{
a vector of the same length as \code{w}.
}
\description{
Computes the Liouville EV model or the scaled Dirichlet EV model spectral density
}
\examples{
hbvevdliouv(seq(0.01,0.99,by=0.01), alpha=c(1,2), rho=0.2, CDA="C")
hbvevdliouv(seq(0.01,0.99,by=0.01), alpha=c(0.1,2), rho=0.2, CDA="S")
hbvevdliouv(seq(0.01,0.99,by=0.01), alpha=c(1,2), rho=0.2, CDA="S", useR=TRUE)
}

