% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarytable.R
\name{summarytable}
\alias{summarytable}
\title{Summary of models}
\usage{
summarytable(
  m1,
  ...,
  which = c("G", "loglik", "npm", "BIC", "\%class"),
  display = TRUE
)
}
\arguments{
\item{m1}{an object of class \code{hlme}, \code{lcmm}, \code{multlcmm}, 
\code{Jointlcmm}, \code{mpjlcmm}, \code{externVar} or \code{externVar}.}

\item{\dots}{further arguments, in particular other objects of class
\code{hlme}, \code{lcmm}, \code{multlcmm}, \code{Jointlcmm} or \code{mpjlcmm}.}

\item{which}{character vector indicating which results should be returned.
Possible values are "G", "loglik", "conv", "npm", "AIC", "BIC", "SABIC",
"entropy", "ICL", "ICL1", "ICL2", "\%class".}

\item{display}{logical indicating whether the table should be printed (the default) or not (display=FALSE)}
}
\value{
a matrix giving for each model the values of the requested indexes.
By default, the number a latent classes, the
log-likelihood, the number of parameters, the BIC and the posterior
probability of the latent classes.
}
\description{
This function provides a table summarizing the results of different models
fitted by \code{hlme}, \code{lcmm}, \code{multlcmm}, \code{Jointlcmm},
\code{mpjlcmm} or \code{externVar}.
}
\details{
Can be reported the usual criteria used to assess the fit and the clustering
 of the data:
 - maximum log-likelihood L (the higher the better)
 - number of parameters P, number of classes G, convergence criterion (1 = converged)
 - AIC (the lower the better) computed as -2L+2P 
 - BIC (the lower the better) computed as -2L+ P log(N) where N is the number of subjects
 - SABIC (the lower the better) computed as -2L+ P log((N+2)/24)
 - Entropy (the closer to one the better) computed in two ways : ICL1 = 1-sum[pi_ig*log(pi_ig)]/(N*log(G))
   where pi_ig is the posterior probability that subject i belongs to class g
 - ICL (the lower the better) computed in two ways : ICL1 = BIC - sum[pi_ig*log(pi_ig)]
   or ICL2 = BIC - 2*sum(log(max(pi_ig)), where the max is taken over the classes for each subject.
 - %Class computed as the proportion of each class based on c_ig
}
\seealso{
\code{\link{summary}}, \code{\link{hlme}}, \code{\link{lcmm}},
\code{\link{multlcmm}}, \code{\link{Jointlcmm}}
}
\author{
Cecile Proust-Lima, Viviane Philipps
}
