% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lazy.matrix.R
\name{lazy.matrix}
\alias{lazy.matrix}
\title{Convert Matrix to LaTeX Table}
\usage{
lazy.matrix(x, align = "center", justify = "center", rcol = NULL,
  usecol = "lightgray", caption = NULL, footnote = NULL,
  placement = "h", translate = TRUE, cat = getOption("lazyWeave_cat"),
  ...)
}
\arguments{
\item{x}{A matrix.  Other objects are coerced to matrices}

\item{align}{Character vector or string giving the alignment for each 
column of the table.  Options are \code{"left", "center", "right"}.}

\item{justify}{Character string giving the alignment for the table on the 
page. Options are \code{"left", "center", "right"}.}

\item{rcol}{A vector giving the rows of \code{x} to be colored}

\item{usecol}{A character string or vector denoting the color of the rows
in \code{rcol}}

\item{caption}{Caption for the table.  This is printed above the table}

\item{footnote}{Additional footnotes for the table.  These are printed
below the table.}

\item{placement}{Controls the placement of the figure.  Options are
\code{"ht", "t", "b", "p", "H"} and can be supplemented with 
\code{"!"}. See "Details" for more explanation. These apply only to LaTeX}

\item{translate}{Toggles if inputs in \code{x} should be passed through 
\code{latexTranslate}.  This should be set to \code{FALSE} if writing
custom code}

\item{cat}{Logical. Determines if the output is returned as a character string
or returned via the \code{cat} function (printed to console).  The default
value is set by \code{options()$lazyWeave_cat}.  This argument allows for
selective override of the default.}

\item{...}{Additional arguments to be passed to \code{lazy.table}}
}
\description{
An example of using \code{lazyWeave} to produce tables
}
\details{
The output for \code{lazy.matrix} is highly inflexible compared 
to \code{lazy.table}.  It is an example of how to build a reproducible 
table with a certain formatting style that may be used again and again
for consistency.

Row names are always left justified.  This cannot be changed.

\code{placement} options are used as follows:
\tabular{ll}{
    ht \tab Place the float here, i.e., 
    approximately at the same point it occurs \cr
    t  \tab Position at the top of the page\cr
b  \tab Position at the bottom of the page \cr
    p  \tab Put on a special page for floats only \cr
    H  \tab Places the float at precisely the location in the LaTeX code. 
    Requires the float package\cr
  }
The \code{"!"} may be used after any of these in order to override 
LaTeX float rules and force your selection.  More can be learned by 
reading about floats in a LaTeX manual
}
\examples{
\dontrun{
lazy.write(
  lazy.file.start(),
  lazy.text("The mtcars dataset describes a number of vehicles.  
      Let's take a look at the data"),
  lazy.matrix(mtcars, rcol=(1:nrow(mtcars))[c(FALSE, TRUE)]),
  lazy.file.end(),
  OutFile="Example 1.tex")

unlink("Example 1.tex")
}

}
\author{
Benjamin Nutter
}
