% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tag.R
\name{lawn_tag}
\alias{lawn_tag}
\title{Spatial join of points and polygons}
\usage{
lawn_tag(points, polygons, field, out_field, lint = FALSE)
}
\arguments{
\item{points}{Input \link{data-FeatureCollection}<(\link{data-Point})>}

\item{polygons}{Input \link{data-FeatureCollection}<(\link{data-Polygon})> or
\link{data-FeatureCollection}<(\link{data-MultiPolygon})>}

\item{field}{Property in polygons to add to joined Point features.}

\item{out_field}{Property in points in which to store joined
property from polygons.}

\item{lint}{(logical) Lint or not. Uses geojsonhint. Takes up increasing
time as the object to get linted increases in size, so probably use by
default for small objects, but not for large if you know they are good
geojson objects. Default: \code{FALSE}}
}
\value{
Points with containing_polyid property containing values
from poly_id, as \link{data-FeatureCollection}<(\link{data-Point})>
}
\description{
Takes a set of \link{data-Point}'s and a set of
\link{data-Polygon}'s and performs a spatial join.
}
\examples{
bbox <- c(0, 0, 10, 10)
pts <- lawn_random(n = 30, bbox = bbox)
polys <- lawn_triangle_grid(bbox, 50, 'miles')
polys$features$properties$fill <- "#f92"
polys$features$properties$stroke <- 0
polys$features$properties$`fill-opacity` <- 1
lawn_tag(pts, polys, 'fill', 'marker-color')
\dontrun{
lawn_tag(pts, polys, 'fill', 'marker-color') \%>\% view
}
}
\seealso{
Other joins: 
\code{\link{lawn_inside}()},
\code{\link{lawn_within}()}
}
\concept{joins}
