% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deviation.R
\name{lawn_deviation}
\alias{lawn_deviation}
\title{Standard deviation of a field among points within polygons}
\usage{
lawn_deviation(
  polygons,
  points,
  in_field,
  out_field = "deviation",
  lint = FALSE
)
}
\arguments{
\item{polygons}{Polygon(s) (\link{data-FeatureCollection}<(\link{data-Polygon})>)
defining area to aggregate}

\item{points}{Points (\link{data-FeatureCollection}<(\link{data-Point})>) with
values to aggregate}

\item{in_field}{Character for the name of the field on \code{pts} on
which you wish to perform the aggregation.}

\item{out_field}{Character for the name of the field on the output
polygon FeatureCollection that will store the resultant value.}

\item{lint}{(logical) Lint or not. Uses geojsonhint. Takes up increasing
time as the object to get linted increases in size, so probably use by
default for small objects, but not for large if you know they are good
geojson objects. Default: \code{FALSE}}
}
\value{
polygons with appended field representing deviation, as a
\link{data-FeatureCollection}
}
\description{
Calculates the population standard deviation (i.e. denominator = n,
not n-1) of values from \link{data-Point}'s within a set of
\link{data-Polygon}'s
}
\examples{
\dontrun{
ex_polys <- lawn_data$polygons_aggregate
ex_pts <- lawn_data$points_aggregate
lawn_deviation(ex_polys, ex_pts, "population")
}
}
\seealso{
Other aggregations: 
\code{\link{lawn_average}()},
\code{\link{lawn_collect}()},
\code{\link{lawn_count}()},
\code{\link{lawn_max}()},
\code{\link{lawn_median}()},
\code{\link{lawn_min}()},
\code{\link{lawn_sum}()},
\code{\link{lawn_variance}()}
}
\author{
Jeff Hollister \email{hollister.jeff@epa.gov}
}
\concept{aggregations}
