% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform_scale.R
\name{lawn_transform_scale}
\alias{lawn_transform_scale}
\title{Scale a GeoJSON feature}
\usage{
lawn_transform_scale(x, factor, origin = "centroid", mutate = FALSE,
  lint = FALSE)
}
\arguments{
\item{x}{a feature}

\item{factor}{(integer/numeric) of scaling, positive or negative values
greater than 0}

\item{origin}{(integer/numeric) Point from which the scaling will occur
(string options: sw/se/nw/ne/center/centroid) (optional, default "centroid")}

\item{mutate}{(logical) allows GeoJSON input to be mutated (significant
performance increase if true) (optional). Default: \code{FALSE}}

\item{lint}{(logical) Lint or not. Uses geojsonhint. Takes up increasing
time as the object to get linted increases in size, so probably use by
default for small objects, but not for large if you know they are good
geojson objects. Default: \code{FALSE}}
}
\value{
a scaled \link{data-Feature}
}
\description{
Scale a GeoJSON from a given point by a factor of scaling (ex: factor=2
would make the GeoJSON 200% larger). If a FeatureCollection is provided,
the origin point will be calculated based on each individual Feature.
}
\examples{
x <- '{
 "type": "Feature",
 "properties": {},
 "geometry": {
   "type": "Polygon",
   "coordinates": [
    [
      [ 0, 29 ], [ 3.5, 29 ], [ 2.5, 32 ], [ 0, 29 ]
    ]
  ]
 }
}'
lawn_transform_scale(x, factor = 3)

lawn_transform_scale(x, factor = 100)
lawn_transform_scale(x, factor = 100, mutate = TRUE)

\dontrun{
view(lawn_featurecollection(x))
view(lawn_featurecollection(
  lawn_transform_scale(x, factor = 2)
))
view(lawn_featurecollection(
  lawn_transform_scale(x, factor = 3)
))
view(lawn_featurecollection(
  lawn_transform_scale(x, factor = 2, origin = "sw")
))
view(lawn_featurecollection(
  lawn_transform_scale(x, factor = 2, origin = "ne")
))
}
}
