% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/countreg.R
\name{countreg}
\alias{countreg}
\title{Fitting Count Regression Models with Latent Covariates}
\usage{
countreg(
  forml,
  lv = NULL,
  group = NULL,
  data,
  family,
  silent = FALSE,
  se = TRUE
)
}
\arguments{
\item{forml}{an object of class for \code{\link[stats]{formula}} (or one that can be coerced to that class): a symbolic description of the model to be fitted. The details of model specification are given under Details.}

\item{lv}{Definition of the latent variables.}

\item{group}{A group variable}

\item{data}{a data frame}

\item{family}{Poisson or negative binomial}

\item{silent}{Should informations about the estimation process be suppressed?}

\item{se}{Should standard errors be computed? (Can take a while for complex models)}
}
\value{
An object of type \code{lavacreg}. Use \code{summary(object)} to print results
containing parameter estimates and their standard errors.
}
\description{
This function is the main function of the package and can be used to estimate
latent variable count regression models in one or multiple group(s).
}
\examples{
fit <- countreg(forml = 'dv ~ z11', data = example01, family = 'poisson')
summary(fit)

\donttest{
fit <- countreg(forml = 'dv ~ eta1 + z11 + z21', 
              lv = list(eta1=c('z41', 'z42', 'z43')),
              group = 'treat',
               data = example01,
             family = 'poisson')
summary(fit)
}

}
