% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sCorrect-effects2.R
\name{effects2}
\alias{effects2}
\alias{effects2.lvmfit}
\alias{effects2.lvmfit2}
\alias{effects.lvmfit2}
\title{Effects Through Pathways With Small Sample Correction}
\usage{
effects2(object, linfct, robust, cluster, conf.level, ...)

\method{effects2}{lvmfit}(
  object,
  linfct,
  robust = FALSE,
  cluster = NULL,
  conf.level = 0.95,
  to = NULL,
  from = NULL,
  df = lava.options()$df,
  ssc = lava.options()$ssc,
  ...
)

\method{effects2}{lvmfit2}(
  object,
  linfct,
  robust = FALSE,
  cluster = NULL,
  conf.level = 0.95,
  to = NULL,
  from = NULL,
  ...
)

\method{effects}{lvmfit2}(
  object,
  linfct,
  robust = FALSE,
  cluster = NULL,
  conf.level = 0.95,
  to = NULL,
  from = NULL,
  ...
)
}
\arguments{
\item{object}{a \code{lvmfit} or \code{lvmfit2} object (i.e. output of \code{lava::estimate} or \code{lavaSearch2::estimate2}).}

\item{linfct}{[character vector] The path for which the effect should be assessed (e.g. \code{"A~B"}),
i.e. the effect of the right variable (B) on the left variable (A).}

\item{robust}{[logical] should robust standard errors be used instead of the model based standard errors? Should be \code{TRUE} if argument cluster is not \code{NULL}.}

\item{cluster}{[integer vector] the grouping variable relative to which the observations are iid.}

\item{conf.level}{[numeric, 0-1] level of the confidence intervals.}

\item{...}{additional argument passed to \code{estimate2} when using a \code{lvmfit} object.}

\item{from, to}{alternative to argument \code{linfct}. See \code{lava::effects}.}

\item{df}{[character] method used to estimate the degree of freedoms of the Wald statistic: Satterthwaite \code{"satterthwaite"}. 
Otherwise (\code{"none"}/code{FALSE}/code{NA}) the degree of freedoms are set to \code{Inf}.
Only relevant when using a \code{lvmfit} object.}

\item{ssc}{[character] method used to correct the small sample bias of the variance coefficients: no correction (code{"none"}/\code{FALSE}/\code{NA}),
correct the first order bias in the residual variance (\code{"residual"}), or correct the first order bias in the estimated coefficients \code{"cox"}).
Only relevant when using a \code{lvmfit} object.}
}
\value{
A data.frame with a row per path.
}
\description{
Test whether a path in the latent variable model correspond to a null effect.
Similar to \code{lava::effects} but with small sample correction (if any).
So far it only work for a single path related two variable composed of one or two edges.
}
\details{
When argument object is a \code{lvmfit} object, the method first calls \code{estimate2} and then extract the confidence intervals.
}
\concept{inference}
\keyword{smallSampleCorrection}
