% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/spaghetti.R
\name{spaghetti}
\alias{spaghetti}
\title{Spaghetti plot}
\usage{
spaghetti(formula, data, id, type = "l", lty = 1, col = Col(1),
  trend = FALSE, trend.col = "darkblue", trend.alpha = 0.2,
  trend.lwd = 3, xlab = "Time", ylab = "", ...)
}
\arguments{
\item{formula}{Formula (response ~ time)}

\item{data}{data.frame}

\item{id}{Id variable}

\item{type}{Type (line 'l', stair 's', ...)}

\item{lty}{Line type}

\item{col}{Colour}

\item{trend}{Add trend line}

\item{trend.col}{Colour of trend line}

\item{trend.alpha}{Transparency}

\item{trend.lwd}{Trend line width}

\item{xlab}{Label of X-axis}

\item{ylab}{Label of Y-axis}

\item{...}{Additional arguments to lower level arguments}
}
\description{
Spaghetti plot for longitudinal data
}
\examples{
\dontrun{
library(mets)
K <- 5
y <- "y"\%++\%seq(K)
m <- lvm()
regression(m,y=y,x=~u) <- 1
regression(m,y=y,x=~s) <- seq(K)-1
regression(m,y=y,x=~x) <- "b"
d <- sim(m,500)
dd <- fast.reshape(d);
dd$num <- dd$num+rnorm(nrow(dd),sd=0.5) ## Unbalance
spaghetti(y~num,dd,id="id",lty=1,col=Col(1,.4),trend=TRUE,trend.col="darkblue")
}
}
\author{
Klaus K. Holst
}

