% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{latrendData}
\alias{latrendData}
\title{Artificial longitudinal dataset comprising three classes}
\format{
A \code{data.frame} comprising longitudinal observations from 200 trajectories.
Each row represents the observed value of a trajectory at a specific moment in time.
\describe{
\item{Id}{\code{integer}: The trajectory identifier.}
\item{Time}{\code{numeric}: The measurement time, between 0 and 2.}
\item{Y}{\code{numeric}: The observed value at the respective time \code{Time} for trajectory \code{Id}.}
\item{Class}{\code{factor}: The reference class.}
}
}
\source{
This dataset was generated using \link{generateLongData}.
}
\usage{
latrendData
}
\description{
An artificial longitudinal dataset comprising 200 trajectories belonging to one of 3 classes.
Each trajectory deviates in intercept and slope from its respective class trajectory.
}
\examples{
data(latrendData)

if (require("ggplot2")) {
  plotTrajectories(latrendData, id = "Id", time = "Time", response = "Y")

  # plot according to the reference class
  plotTrajectories(latrendData, id = "Id", time = "Time", response = "Y", cluster = "Class")
}
}
\seealso{
\link{generateLongData}
}
\keyword{datasets}
