% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method.R, R/model.R
\name{timeVariable}
\alias{timeVariable}
\alias{timeVariable,lcMethod-method}
\alias{timeVariable,lcModel-method}
\title{Extract the time variable}
\usage{
\S4method{timeVariable}{lcMethod}(object, ...)

\S4method{timeVariable}{lcModel}(object)
}
\arguments{
\item{object}{The object to extract the variable from.}

\item{...}{Additional arguments.}
}
\value{
The time variable name, as \code{character}.
}
\description{
Extracts the time variable (i.e., column name) from the given \code{object}.
}
\examples{
method <- lcMethodKML(time = "Assessment")
timeVariable(method) # "Assessment"

data(latrendData)
model <- latrend(lcMethodKML("Y", id = "Id", time = "Time"), latrendData)
idVariable(model) # "Id"
}
\seealso{
Other lcModel variables: 
\code{\link{idVariable}()},
\code{\link{responseVariable}()}
}
\concept{lcModel variables}
