% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R, R/model.R
\name{plotClusterTrajectories}
\alias{plotClusterTrajectories}
\alias{plotClusterTrajectories,data.frame-method}
\alias{plotClusterTrajectories,lcModel-method}
\title{Plot cluster trajectories}
\usage{
\S4method{plotClusterTrajectories}{data.frame}(
  object,
  response,
  cluster = "Cluster",
  time = getOption("latrend.time"),
  center = meanNA,
  trajectories = FALSE,
  facet = isTRUE(trajectories),
  id = getOption("latrend.id"),
  ...
)

\S4method{plotClusterTrajectories}{lcModel}(
  object,
  what = "mu",
  at = time(object),
  clusterLabels = sprintf("\%s (\%s)", clusterNames(object),
    percent(clusterProportions(object))),
  trajectories = FALSE,
  facet = isTRUE(trajectories),
  trajAssignments = trajectoryAssignments(object),
  ...
)
}
\arguments{
\item{object}{The (cluster) trajectory data.}

\item{response}{The name of the response variable.}

\item{cluster}{The cluster assignment column}

\item{time}{The name of the time variable.}

\item{center}{A function for aggregating multiple points at the same point in time}

\item{trajectories}{Whether to plot the original data in addition to the cluster (i.e., center) trajectories}

\item{facet}{Whether to facet by cluster. This is done by default when \code{trajectories} is enabled.}

\item{id}{Id column. Only needed when \code{trajectories = TRUE}.}

\item{...}{Arguments passed to \link{clusterTrajectories}, or \link[ggplot2:geom_path]{ggplot2::geom_line} for plotting the cluster trajectory lines.}

\item{what}{The distributional parameter to predict. By default, the mean response 'mu' is predicted. The cluster membership predictions can be obtained by specifying \code{what = 'mb'}.}

\item{at}{An optional vector, list or data frame of covariates at which to compute the cluster trajectory predictions.
If a vector is specified, this is assumed to be the time covariate. Otherwise, a named list or data frame must be provided.}

\item{clusterLabels}{Cluster display names. By default it's the cluster name with its proportion enclosed in parentheses.}

\item{trajAssignments}{The cluster assignments for the fitted trajectories. Only used when \code{trajectories = TRUE} and \code{facet = TRUE}. See \link{trajectoryAssignments}.}
}
\value{
A \code{ggplot} object.
}
\description{
Plot cluster trajectories

Plot the cluster trajectories of a lcModel
}
\details{
Instead of passing the plotting arguments through \code{...}, consider modifying the ggplot2 defaults.
For example, changing the default line size: \code{update_geom_defaults("line", list(size = 1.5))}
}
