% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{lcModels}
\alias{lcModels}
\title{Construct a flat (named) list of lcModel objects}
\usage{
lcModels(...)
}
\arguments{
\item{...}{\code{lcModel}, \code{lcModels}, or a recursive \code{list} of \code{lcModel} objects. Arguments may be named.}
}
\value{
A \code{lcModels} object containing all specified \code{lcModel} objects.
}
\description{
Takes the inputs and generates a named \code{lcModels} object containing a list of the input models. Duplicates are preserved.
}
\examples{
data(latrendData)
kml <- latrend(lcMethodKML("Y", id = "Id", time = "Time"), latrendData)
gmm <- latrend(lcMethodLcmmGMM(fixed = Y ~ Time, mixture = ~ Time,
   id = "Id", time = "Time"), latrendData)
lcModels(kml, gmm)

lcModels(defaults = c(kml, gmm))
}
\seealso{
Other lcModel list functions: 
\code{\link{as.lcModels}()},
\code{\link{print.lcModels}()},
\code{\link{subset.lcModels}()}
}
\concept{lcModel list functions}
