% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methodAKMedoids.R
\name{lcMethodAkmedoids}
\alias{lcMethodAkmedoids}
\title{Specify AKMedoids method}
\usage{
lcMethodAkmedoids(
  response,
  time = getOption("latrend.time"),
  id = getOption("latrend.id"),
  nClusters = 3,
  clusterCenter = median,
  ...
)
}
\arguments{
\item{response}{The name of the response variable.}

\item{time}{The name of the time variable.}

\item{id}{The name of the trajectory identification variable.}

\item{nClusters}{The number of clusters to estimate.}

\item{clusterCenter}{A function for computing the cluster center representation.}

\item{...}{Arguments passed to \link[akmedoids:akmedoids.clust]{akmedoids::akmedoids.clust}.
The following external arguments are ignored: traj, id_field, k}
}
\description{
Specify AKMedoids method
}
\examples{
library(akmedoids)
data(latrendData)
method <- lcMethodAkmedoids(response = "Y", time = "Time", id = "Id", nClusters = 3)
model <- latrend(method, data = latrendData)
}
\references{
\insertRef{adepeju2020akmedoids}{latrend}
}
\seealso{
Other lcMethod implementations: 
\code{\link{lcMethod-class}},
\code{\link{lcMethodCrimCV}},
\code{\link{lcMethodCustom}},
\code{\link{lcMethodDtwclust}},
\code{\link{lcMethodFeature}},
\code{\link{lcMethodFunFEM}},
\code{\link{lcMethodGCKM}},
\code{\link{lcMethodKML}},
\code{\link{lcMethodLMKM}},
\code{\link{lcMethodLcmmGBTM}},
\code{\link{lcMethodLcmmGMM}},
\code{\link{lcMethodLongclust}},
\code{\link{lcMethodMclustLLPA}},
\code{\link{lcMethodMixAK_GLMM}},
\code{\link{lcMethodMixtoolsGMM}},
\code{\link{lcMethodMixtoolsNPRM}},
\code{\link{lcMethodRandom}},
\code{\link{lcMethodStratify}}
}
\concept{lcMethod implementations}
