% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method.R, R/model.R
\name{idVariable}
\alias{idVariable}
\alias{idVariable,lcMethod-method}
\alias{idVariable,lcModel-method}
\title{Extract the trajectory identifier variable}
\usage{
\S4method{idVariable}{lcMethod}(object, ...)

\S4method{idVariable}{lcModel}(object)
}
\arguments{
\item{object}{The object to extract the variable from.}

\item{...}{Not used.}
}
\value{
The trajectory identifier name, as \code{character}.
}
\description{
Extracts the trajectory identifier variable (i.e., column name) from the given \code{object}.
}
\examples{
method <- lcMethodKML(id = "Traj")
idVariable(method) # "Traj"

model <- latrend(lcMethodKML("Y", id = "Id", time = "Time"), latrendData)
idVariable(model) # "Id"

}
\seealso{
Other lcModel variables: 
\code{\link{responseVariable}()},
\code{\link{timeVariable}()}
}
\concept{lcModel variables}
