% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipol.R
\name{ipol}
\alias{ipol}
\title{Create an interpolating function from given values. Several interpolation methods are
supported.}
\usage{
ipol(val, grid = NULL, ...)
}
\arguments{
\item{val}{array or function. Function values on a grid.}

\item{grid}{list. Each element is a vector of ordered grid-points for a
dimension.}

\item{...}{Further arguments to the function, if \code{is.function(val)}. And some
extra arguments for interpolant creation described in section Details.}
}
\value{
A \code{function(x, threads=getOption('chebpol.threads'))} defined on a hypercube, an \link{interpolant}
for the given function. The argument \code{x} can be a matrix of column
vectors which are evaluated in parallel in a number of threads.  The
function yields values for arguments outside the hypercube as well, though
it will typically be a poor approximation.  \code{threads} is an integer
specifying the number of parallel threads which should be used when
evaluating a matrix of column vectors.
}
\description{
Create an interpolating function from given values. Several interpolation methods are
supported.
}
\examples{

## evenly spaced grid-points
su <- seq(0,1,length.out=10)
## irregularly spaced grid-points
s <- su^3
## create approximation on the irregularly spaced grid
ml1 <- ipol(exp(s), grid=list(s))
## test it, since exp is convex, the linear approximation lies above
## the exp between the grid points
ml1(su) - exp(su)

## multi dimensional approximation
f <- function(x) 10/(1+25*mean(x^2))
# a 3-dimensional 10x10x10 grid, first and third coordinate are non-uniform
grid <- list(s, su, sort(1-s))

# make multilinear spline.
ml2 <- ipol(array(apply(expand.grid(grid), 1, f), c(10, 10, 10)), grid=grid)
# make 7 points in R3 to test them on
m <- matrix(runif(3*7),3)
rbind(true=apply(m,2,f), ml=ml2(m))

}
\author{
Simen Gaure
}
