% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trees.R
\name{tree_var}
\alias{tree_var}
\title{Recursive Partitioning and Regression Trees}
\usage{
tree_var(
  df,
  target,
  max = 3,
  min = 20,
  cp = 0,
  size = 0.7,
  ohse = TRUE,
  plot = TRUE,
  ...
)
}
\arguments{
\item{df}{Data frame}

\item{target}{Variable}

\item{max}{Integer. Maximal depth of the tree}

\item{min}{Integer. The minimum number of observations that must 
exist in a node in order for a split to be attempted}

\item{cp}{Numeric. Complexity parameter}

\item{size}{Numeric. Textsize of plot}

\item{ohse}{Boolean. Auto generate One Hot Smart Encoding?}

\item{plot}{Boolean. Return a plot? If not, \code{rpart} object}

\item{...}{rpart.plot custom parameters}
}
\value{
When \code{plot=TRUE} returns plot; when \code{plot=FALSE}
returns \code{rpart} fitted model.
}
\description{
Fit and plot a rpart model for exploratory purposes using rpart
and rpart.plot libraries. Idea from explore library.
}
\seealso{
Other Exploratory: 
\code{\link{corr_cross}()},
\code{\link{corr_var}()},
\code{\link{crosstab}()},
\code{\link{df_str}()},
\code{\link{distr}()},
\code{\link{freqs_df}()},
\code{\link{freqs_list}()},
\code{\link{freqs_plot}()},
\code{\link{freqs}()},
\code{\link{lasso_vars}()},
\code{\link{missingness}()},
\code{\link{plot_cats}()},
\code{\link{plot_df}()},
\code{\link{plot_nums}()},
\code{\link{trendsRelated}()}

Other Visualization: 
\code{\link{distr}()},
\code{\link{freqs_df}()},
\code{\link{freqs_list}()},
\code{\link{freqs_plot}()},
\code{\link{freqs}()},
\code{\link{gg_bars}()},
\code{\link{gg_pie}()},
\code{\link{noPlot}()},
\code{\link{plot_chord}()},
\code{\link{plot_survey}()},
\code{\link{plot_timeline}()},
\code{\link{theme_lares}()}
}
\concept{Exploratory}
\concept{Visualization}
