% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other_functions.R
\name{files_functions}
\alias{files_functions}
\title{List all functions used in R script files by package}
\usage{
files_functions(filename, abc = TRUE, quiet = FALSE)
}
\arguments{
\item{filename}{Character. Path to an R file (or directory)
containing R code files.}

\item{abc}{Boolean. List functions alphabetically.
If FALSE, will list in order of frequency.}

\item{quiet}{Boolean. Keep quiet? If not, print messages and
\code{statusbar}.}
}
\value{
data.frame. Each row is a function and columns stating
number of appearances, percentage, packages, and files searched.
}
\description{
Parses all functions called by an R script and then lists
them by package. Wrapper for 'getParseData'. May be of great
use for those developing a package to help see what 
namespace 'importsFrom' calls will be required.
}
\examples{
\dontrun{
# Choose an R script file with functions
rfile <- file.choose()
files_functions(rfile)
}
}
