% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_plots.R
\name{mplot_splits}
\alias{mplot_splits}
\title{Split and compare quantiles plot}
\usage{
mplot_splits(
  tag,
  score,
  splits = 5,
  subtitle = NA,
  model_name = NA,
  save = FALSE,
  subdir = NA,
  file_name = "viz_splits.png"
)
}
\arguments{
\item{tag}{Vector. Real known label.}

\item{score}{Vector. Predicted value or model's result.}

\item{splits}{Integer. Number of separations to plot}

\item{subtitle}{Character. Subtitle to show in plot}

\item{model_name}{Character. Model's name}

\item{save}{Boolean. Save output plot into working directory}

\item{subdir}{Character. Sub directory on which you wish to save the plot}

\item{file_name}{Character. File name as you wish to save the plot}
}
\value{
Plot with distribution and performance results by splits.
}
\description{
This function lets us split and compare quantiles on a given prediction to
compare different categorical values vs scores grouped by equal sized buckets.
}
\examples{
Sys.unsetenv("LARES_FONT") # Temporal
data(dfr) # Results for AutoML Predictions
lapply(dfr, head)

# For categorical (binary) values
mplot_splits(dfr$class2$tag, dfr$class2$scores,
             splits = 4,
             model_name = "Titanic Survived Model")

# For categorical (+2) values
mplot_splits(dfr$class3$tag, dfr$class2$scores,
             model_name = "Titanic Class Model")

# For continuous values
mplot_splits(dfr$regr$tag, dfr$regr$score, splits = 4,
             model_name = "Titanic Fare Model")
}
\seealso{
Other ML Visualization: 
\code{\link{mplot_conf}()},
\code{\link{mplot_cuts_error}()},
\code{\link{mplot_cuts}()},
\code{\link{mplot_density}()},
\code{\link{mplot_full}()},
\code{\link{mplot_gain}()},
\code{\link{mplot_importance}()},
\code{\link{mplot_lineal}()},
\code{\link{mplot_metrics}()},
\code{\link{mplot_response}()},
\code{\link{mplot_roc}()},
\code{\link{mplot_topcats}()}
}
\concept{ML Visualization}
