% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Methods-LandsepiParams.R
\name{setCroptypes}
\alias{setCroptypes}
\title{Set croptypes}
\usage{
setCroptypes(params, dfCroptypes)
}
\arguments{
\item{params}{a LandsepiParams Object.}

\item{dfCroptypes}{a data.frame containing cultivar proportions in each croptype (see details).
It can be generated manually, or initialised with \code{\link{loadCroptypes}} and later
updated with \code{\link{allocateCroptypeCultivars}}.}
}
\value{
a LandsepiParams object
}
\description{
Updates a LandsepiParams object with croptypes and their composition with regard
to cultivar proportions.
Note that landscape and cultivar parameters may be required if not all information is
present to set croptypes.
}
\details{
The data.frame for cultivar allocations into croptypes must take this format (example):\tabular{lllll}{
   croptypeID \tab croptypeName \tab cultivarName1 \tab cultivarName2 \tab ... \cr
   0 \tab "cropt1" \tab 1 \tab 0 \tab ... \cr
   1 \tab "cropt2" \tab 0.5 \tab 0.5 \tab ... \cr
}


croptypeIDs must start at 0 and match with values from landscape "croptypeID" layer with
feature year_X.
Cultivars names have to match cultivar names in the cultivars data.frame.
}
\examples{
\dontrun{
simul_params <- createSimulParams()
cultivar1 <- loadCultivar(name = "Susceptible", type = "growingHost")
cultivar2 <- loadCultivar(name = "Resistant1", type = "growingHost")
cultivar3 <- loadCultivar(name = "Resistant2", type = "growingHost")
cultivars <- data.frame(rbind(cultivar1, cultivar2, cultivar3), stringsAsFactors = FALSE)
simul_params <- setCultivars(simul_params, cultivars)
croptypes <- loadCroptypes(simul_params, names = c("Susceptible crop", "Mixture"))
croptypes <- allocateCroptypeCultivars(croptypes, "Susceptible crop", "Susceptible")
croptypes <- allocateCroptypeCultivars(croptypes, "Mixture", c("Resistant1", "Resistant2"))
simul_params <- setCroptypes(simul_params, croptypes)
simul_params@Croptypes
}
}
\seealso{
\link{loadCroptypes}
}
