% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Methods-LandsepiParams.R
\name{loadCroptypes}
\alias{loadCroptypes}
\title{Load Croptypes}
\usage{
loadCroptypes(params, croptypeIDs = NULL, names = NULL)
}
\arguments{
\item{params}{a LandsepiParams Object.}

\item{croptypeIDs}{a vector of indices of croptypes (must start at 0 and match with croptype IDs in the landscape)}

\item{names}{a vector containing the names of all croptypes}
}
\value{
a data.frame with croptype parameters
}
\description{
Creates a data.frame containing croptype parameters and filled with 0
}
\details{
Croptypes need to be later updated with \code{\link{allocateCroptypeCultivars}}.
If neither croptypeIDs nor names are given, it will automatically generate
1 croptype per cultivar.
}
\examples{
\dontrun{
simul_params <- createSimulParams()
cultivar1 <- loadCultivar(name = "Susceptible", type = "growingHost")
cultivar2 <- loadCultivar(name = "Resistant1", type = "growingHost")
cultivar3 <- loadCultivar(name = "Resistant2", type = "growingHost")
cultivars <- data.frame(rbind(cultivar1, cultivar2, cultivar3), stringsAsFactors = FALSE)
simul_params <- setCultivars(simul_params, cultivars)
croptypes <- loadCroptypes(simul_params, names = c("Susceptible crop", "Mixture"))
croptypes
}
}
\seealso{
\link{setCroptypes}
}
