% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Methods-LandsepiParams.R
\name{setTime}
\alias{setTime}
\title{Set time parameters}
\usage{
setTime(params, Nyears, nTSpY)
}
\arguments{
\item{params}{a LandsepiParams Object.}

\item{Nyears}{an integer giving the number of cropping seasons (e.g. years) to simulate.}

\item{nTSpY}{an integer giving the number of time steps per cropping season (e.g. days).}
}
\value{
a LandsepiParams object.
}
\description{
Updates a LandsepiParams object with time parameters : Nyears and nTSpY
}
\examples{
\dontrun{
simul_params <- createSimulParams()
simul_params <- setTime(simul_params, Nyears=10, nTSpY=120)
simul_params@TimeParam
}
}
