% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Methods-LandsepiParams.R
\name{setInoculum}
\alias{setInoculum}
\title{Set inoculum}
\usage{
setInoculum(params, val = 5e-04)
}
\arguments{
\item{params}{a LandsepiParams object.}

\item{val}{a numeric value (default = 5e-4). Must be between 0 and 1.}
}
\value{
a LandsepiParams object
}
\description{
Updates a LandsepiParams with the initial probability for the first host
(whose index is 0) to be infectious (i.e. state I) at the beginning of the simulation.
}
\examples{
\dontrun{
simul_params <- createSimulParams()
simul_params <- setInoculum(simul_params, 1E-3)
simul_params@PI0
}
}
