% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{modelLandsEPI}
\alias{modelLandsEPI}
\title{Model Landscape Epidemiology & Evolution}
\usage{
modelLandsEPI(times, landscape, dispersal, inits, val_seed, hostP, epiP, evolP)
}
\arguments{
\item{times}{list of simulation parameters (number of years, number of time-steps per year)}

\item{landscape}{landscape generated through AgriLand}

\item{dispersal}{list of dispersal parameters (vectorised dispersal matrix of the pathogen, vectorised dispersal matrix of the host)}

\item{inits}{list initial conditions (host planting density, initial probability of infection by the pathogen)}

\item{val_seed}{seed (for random number generation)}

\item{hostP}{list of host parameters (number of cultivars, growth rate of the susceptible cultivar, reproduction rate of the susceptible cultivar, 
growth rate of resistant cultivars, reproduction rate of resistant cultivars, death rate, resistance formula, 
parameters of the sigmoid invasion function: kappa, sigma and s)}

\item{epiP}{list of pathogen parameters (probability to survive the off-season, infection rate
, reproduction rate, average latent period duration, variance of the latent period, average infectious period duration
, variance of the infectious period duration, parameters of the sigmoid contamination function: kappa, sigma, s)}

\item{evolP}{list of evolution parameters (cost of infectivity, cost of aggressiveness, mutation rate, efficiency of major 
resistance genes, efficiency of quantitative resistance, trade-off strength, number of increments of quantitative 
resistance erosion, adaptation formula)}
}
\value{
A set of binary files is generated for every year of simulation and every compartment: \itemize{ 
\item H: healthy hosts,
\item Hjuv: juvenile healthy hosts,
\item L: latently infected hosts,
\item I: infectious hosts,
\item R: removed hosts,
\item S: propagules.
} 
Each file indicates for every time-step the number of individuals in each field, and when appropriate for each cultivar and pathotype)
}
\description{
Stochastic, spatially-explicit, demo-genetic model simulating the spread and evolution of a pathogen in a heterogeneous landscape.
}
\details{
\itemize{
\item The model is stochastic, spatially explicit (the basic spatial unit is an individual field), based on a SEIR 
(‘susceptible-exposed-infectious-removed’) structure with a discrete time step. It simulates the spread and evolution 
of a pathogen in an agricultural landscape, across cropping seasons split by host harvests which impose potential bottlenecks 
to the pathogen. 
\item A wide array of deployment strategies can be simulated: mosaics, mixtures, rotations and pyramiding of multiple
 major resistance genes which affect pathogen infectivity, and up to four quantitative resistance traits. 
 These traits target different aggressiveness components of the pathogen, i.e. the infection rate, the duration of the latent 
 period and the infectious period, and the propagule production rate. 
 \item The genotype of cultivated plant cultivars is specified using 
 the "resistance formulas", i.e. a vector of size 8. the four first elements indicate whether the cultivar carries major resistance 
 genes #1, #2, #3 and #4, respectively. The following four elements indicate whether the cultivar carried a quantitative resistance 
 trait against the infection rate, the latent period duration, the sporulation rate, or the sporulation duration of the pathogen, respectively. 
 For example, the formula c(1,0,0,0,0,1,0,0) indicates the presence of major gene #1 and a quantitative resistance 
 which increases the duration of the latent period of the pathogen.
 \item Initially, the pathogen is not adapted to any source of 
 resistance, and is only present on susceptible hosts. However, through mutation, it can evolve and may acquire infectivity 
 genes (which leads to breakdown of major resistance genes) or increase aggressiveness (which leads to the erosion of the 
 relevant quantitative resistance traits). 
 \item Evolution of a pathogen toward infectivity or increased aggressiveness on 
 a resistant host is often penalised by a fitness cost on susceptible hosts. Consequently, in the present model, pathogens 
 carrying infectivity genes may have reduced infection rate (cost of infectivity) on susceptible hosts relative 
 to pathogens that do not carry these genes. Similarly, a gain in pathogen aggressiveness on quantitatively resistant hosts 
 is penalised by a decreased aggressiveness on susceptible hosts, leading to a trade-off.
 }
}
\references{
Rimbaud L., Papaïx J., Rey J.-F., Barrett L. G. and Thrall P. H. (2018). Assessing the durability and efficiency of landscape-based strategies to deploy plant resistance to pathogens. \emph{PLoS Computational Biology} 14(4):e1006067.
}
