% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract-context.R
\name{extract_context}
\alias{extract_context}
\title{Extract the context of a Lambda invocation from the headers of an event}
\usage{
extract_context(event, config, ...)
}
\arguments{
\item{event}{the response received from querying the next invocation
endpoint.}

\item{config}{A list of configuration values as created by the
\code{lambda_config} function.}
}
\value{
list
}
\description{
Extract the context of a Lambda invocation from the headers of an event
}
\section{Event context}{

Context is metadata associated with each invocation. If the handler function
accepts a \code{context} argument then it will automatically receive at runtime a
named list consisting of these values along with the arguments in the body
(if any). For example, a function such as \code{my_func(x, context)} will receive
the context argument automatically. The \code{context} argument must be named
(\code{...} will not work).

Refer to \code{vignette("lambda-runtime-in-container", package = "lambdr")}
for details.
}

\keyword{internal}
