% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VisualizationFunctions.R
\name{plot_velocity_profiles}
\alias{plot_velocity_profiles}
\title{Create ggplot of saccade velocity profiles}
\usage{
plot_velocity_profiles(saccades, onset = NA, offset = NA, verbose = TRUE)
}
\arguments{
\item{saccades}{data frame including saccades. Each saccade must have a list with a vector of the veloctity profiles}

\item{onset}{first saccade to plot. The value must correspond to a number in the variable "number" in the saccades data frame. If left empty, all saccades are plotted}

\item{offset}{last saccade to plot. The value must correspond to a number in the variable "number" in the saccades data frame.}

\item{verbose}{If TRUE, print the resulting plot}
}
\value{
ggplot with velocity profiles
}
\description{
This function plots and returns a ggplot showing velocity profiles of saccades plotted against time. Saccades should be generated with the ivt.filter functions with
the save.velosity.profiles parameter set to TRUE. The interval to plot is defined by saccade number as they appear in the sacccades data frame.
}
\examples{
new.plot <- plot_velocity_profiles(sample.data.saccades, onset = 10, offset = 20)
}
