% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_method_freq.analysis.R
\name{freq.analysis}
\alias{freq.analysis}
\alias{freq.analysis,kRp.text-method}
\title{Analyze word frequencies}
\usage{
freq.analysis(txt.file, ...)

\S4method{freq.analysis}{kRp.text}(
  txt.file,
  corp.freq = NULL,
  desc.stat = TRUE,
  corp.rm.class = "nonpunct",
  corp.rm.tag = c()
)
}
\arguments{
\item{txt.file}{An object of class \code{\link[koRpus:kRp.text-class]{kRp.text}}.}

\item{...}{Additional options for the generic.}

\item{corp.freq}{An object of class \code{\link[koRpus:kRp.corp.freq-class]{kRp.corp.freq}}.}

\item{desc.stat}{Logical,
      whether an updated descriptive statistical analysis should be conducted.}

\item{corp.rm.class}{A character vector with word classes which should be ignored for frequency analysis. The default value
\code{"nonpunct"} has special meaning and will cause the result of
\code{kRp.POS.tags(lang, tags=c("punct","sentc"), list.classes=TRUE)} to be used.}

\item{corp.rm.tag}{A character vector with POS tags which should be ignored for frequency analysis.}
}
\value{
An updated object of class \code{\link[koRpus:kRp.text-class]{kRp.text}} with the added feature \code{freq},
   which is a list with information on the word frequencies of the analyzed text.
   Use \code{\link[koRpus:corpusFreq]{corpusFreq}} to get that slot.
}
\description{
The function \code{freq.analysis} analyzes texts regarding frequencies of tokens,
      word classes etc.
}
\details{
It adds new columns with frequency information to the \code{tokens} data frame of the input data,
describing how often the particular token is used in the additionally provided corpus frequency object.

To get the results, you can use \code{taggedText} to get the \code{tokens} slot,
      \code{describe} to get
the raw descriptive statistics (only updated if \code{desc.stat=TRUE}),
      and \code{corpusFreq} to get
the data from the added \code{freq} feature.

If \code{corp.freq} provides appropriate idf values for the types in \code{txt.file}, the
term frequency--inverse document frequency statistic (tf-idf) will also be computed.
Missing idf values will result in \code{NA}.
}
\examples{
\dontrun{
freq.analysis(tagged.text, corp.freq=my.LCC.data)
}
}
\seealso{
\code{\link[koRpus:get.kRp.env]{get.kRp.env}},
      \code{\link[koRpus:kRp.text-class]{kRp.text}},
   \code{\link[koRpus:kRp.corp.freq-class]{kRp.corp.freq}}
}
\keyword{misc}
