% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmeRs_heatmap.R
\name{kmeRs_heatmap}
\alias{kmeRs_heatmap}
\title{K-mer similarity score heatmap}
\usage{
kmeRs_heatmap(
  x,
  cexRow = NULL,
  cexCol = NULL,
  col = NULL,
  Colv = NA,
  Rowv = NA
)
}
\arguments{
\item{x}{matrix calculated by \code{kmeRs_similarity_matrix} function}

\item{cexRow}{= NULL}

\item{cexCol}{= NULL}

\item{col}{color palette, when NULL the default palette is applied}

\item{Colv}{when different from NA, the column dendrogram is shown}

\item{Rowv}{when different from NA, the row dendrogram is shown}
}
\value{
heatmap from results
}
\description{
The \code{kmeRs_heatmap} function generates a heatmap from similarity score matrix
}
\examples{
# Use RColorBrewer to generate a figure similar to publication
library(RColorBrewer)
h.palette <- rev(brewer.pal(9, "YlGnBu"))
q0 <- c("GATTACA", "ACAGATT", "GAATTAC", "GAAATCT", "CTATAGA", "GTACATA", "AACGATT")
example <- kmeRs_similarity_matrix(q0, submat = "BLOSUM62")
kmeRs_heatmap(kmeRs_score(example), col = h.palette)
}
