% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/floodlight_for_contrasts.R
\name{floodlight_for_contrasts}
\alias{floodlight_for_contrasts}
\title{Floodlight Analyses for a Set of Contrasts}
\usage{
floodlight_for_contrasts(
  data = NULL,
  iv_name = NULL,
  dv_name = NULL,
  mod_name = NULL,
  contrasts = NULL,
  contrasts_for_floodlight = NULL,
  covariate_name = NULL,
  interaction_p_include = TRUE,
  iv_category_order = NULL,
  heteroskedasticity_consistent_se = "HC4",
  round_r_squared = 3,
  round_f = 2,
  sigfigs = 2,
  jn_points_disregard_threshold = NULL,
  print_floodlight_plots = TRUE,
  output = "reg_lines_plot",
  jitter_x_percent = 0,
  jitter_y_percent = 0,
  dot_alpha = 0.5,
  dot_size = 4,
  interaction_p_value_font_size = 6,
  jn_point_font_size = 6,
  jn_point_label_hjust = NULL,
  interaction_p_vjust = -3,
  plot_margin = ggplot2::unit(c(75, 7, 7, 7), "pt"),
  legend_position = "right",
  line_of_fit_types = c("solid", "dashed"),
  line_of_fit_thickness = 1.5,
  jn_line_types = c("solid", "solid"),
  jn_line_thickness = 1.5,
  sig_region_color = "green",
  sig_region_alpha = 0.08,
  nonsig_region_color = "gray",
  nonsig_region_alpha = 0.08,
  x_axis_title = NULL,
  y_axis_title = NULL,
  legend_title = NULL,
  round_decimals_int_p_value = 3,
  round_jn_point_labels = 2
)
}
\arguments{
\item{data}{a data object (a data frame or a data.table)}

\item{iv_name}{name of the multicategorical independent variable;
this variable must have three or more categories.}

\item{dv_name}{name of the dependent variable}

\item{mod_name}{name of the continuous moderator variable}

\item{contrasts}{names of the contrast variables}

\item{contrasts_for_floodlight}{names of the contrast variables for
which floodlight analyses will be conducted}

\item{covariate_name}{name of the variables to control for}

\item{interaction_p_include}{logical. Should the plot include a
p-value for the interaction term?}

\item{iv_category_order}{order of levels in the independent
variable for legend. By default, it will be set as levels of the
independent variable ordered using R's base function \code{sort}.}

\item{heteroskedasticity_consistent_se}{which kind of
heteroskedasticity-consistent (robust) standard errors should be
calculated? (default = "HC4")}

\item{round_r_squared}{number of decimal places to which to round
r-squared values (default = 3)}

\item{round_f}{number of decimal places to which to round
the f statistic for model comparison (default = 2)}

\item{sigfigs}{number of significant digits to round to
(for values in the regression tables, except for p values).
By default \code{sigfigs = 2}}

\item{jn_points_disregard_threshold}{the Minimum Distance in
the unit of the moderator variable that will be used for various purposes,
such as (1) to disregard the second Johnson-Neyman point
that is different from the first Johnson-Neyman (JN) point by
less than the Minimum Distance; (2) to determine regions of
significance, which will calculate the p-value of the IV's effect
(the focal dummy variable's effect) on DV at a candidate
JN point + / - the Minimum Distance.
This input is hard to explain, but a user can enter a really low value
for this argument (e.g., \code{jn_points_disregard_threshold = 0.1}
for a moderator measured on a 100-point scale) or use the default.
By default, \code{
jn_points_disregard_threshold = range of the moderator / 10000}
For example, if the observed moderator values range from 1 to 7
(because it is a 7-point scale), then \code{
jn_points_disregard_threshold = (7 - 1) / 10000 = 0.0006}}

\item{print_floodlight_plots}{If \code{print_floodlight_plots = TRUE},
a floodlight plot for each dummy variable will be printed.
By default, \code{print_floodlight_plots = TRUE}}

\item{output}{output of the function (default = "all").
Possible inputs: "reg_models", "reg_tables", "reg_tables_rounded",
"all"}

\item{jitter_x_percent}{horizontally jitter dots by a percentage of the
range of x values}

\item{jitter_y_percent}{vertically jitter dots by a percentage of the
range of y values}

\item{dot_alpha}{opacity of the dots (0 = completely transparent,
1 = completely opaque). By default, \code{dot_alpha = 0.5}}

\item{dot_size}{size of the dots (default = 4)}

\item{interaction_p_value_font_size}{font size for the interaction
p value (default = 8)}

\item{jn_point_font_size}{font size for Johnson-Neyman point labels
(default = 6)}

\item{jn_point_label_hjust}{a vector of hjust values for
Johnson-Neyman point labels. By default, the hjust value will be 0.5 for
all the points.}

\item{interaction_p_vjust}{By how much should the label for the
interaction p-value be adjusted vertically?
By default, \code{interaction_p_vjust = -3})}

\item{plot_margin}{margin for the plot
By default \code{plot_margin = ggplot2::unit(c(75, 7, 7, 7), "pt")}}

\item{legend_position}{position of the legend (default = "right").
If \code{legend_position = "none"}, the legend will be removed.}

\item{line_of_fit_types}{types of the lines of fit for the two levels
of the independent variable.
By default, \code{line_of_fit_types = c("solid", "dashed")}}

\item{line_of_fit_thickness}{thickness of the lines of fit (default = 1.5)}

\item{jn_line_types}{types of the lines for Johnson-Neyman points.
By default, \code{jn_line_types = c("solid", "solid")}}

\item{jn_line_thickness}{thickness of the lines at Johnson-Neyman points
(default = 1.5)}

\item{sig_region_color}{color of the significant region, i.e., range(s)
of the moderator variable for which simple effect of the independent
variable on the dependent variable is statistically significant.}

\item{sig_region_alpha}{opacity for \code{sig_region_color}.
(0 = completely transparent, 1 = completely opaque).
By default, \code{sig_region_alpha = 0.08}}

\item{nonsig_region_color}{color of the non-significant region,
i.e., range(s) of the moderator variable for which simple effect of
the independent variable on the dependent variable is not
statistically significant.}

\item{nonsig_region_alpha}{opacity for \code{nonsig_region_color}.
(0 = completely transparent, 1 = completely opaque).
By default, \code{nonsig_region_alpha = 0.08}}

\item{x_axis_title}{title of the x axis. By default, it will be set
as input for \code{mod_name}. If \code{x_axis_title = FALSE}, it will
be removed.}

\item{y_axis_title}{title of the y axis. By default, it will be set
as input for \code{dv_name}. If \code{y_axis_title = FALSE}, it will
be removed.}

\item{legend_title}{title of the legend. By default, it will be set
as input for \code{iv_name}. If \code{legend_title = FALSE}, it will
be removed.}

\item{round_decimals_int_p_value}{To how many digits after the
decimal point should the p value for the interaction term be
rounded? (default = 3)}

\item{round_jn_point_labels}{To how many digits after the
decimal point should the jn point labels be rounded? (default = 2)}
}
\description{
Conduct a floodlight analysis for a set of contrasts with a
continuous moderator variable.
}
\details{
See the following reference, which covers a related topic:
Hayes & Montoya (2017) \doi{10.1080/19312458.2016.1271116}
}
\examples{
\dontrun{
# typical example
# copy and modify the 'mtcars' data
mtcars2 <- setDT(data.table::copy(mtcars))
# make sure the data table package is attached
mtcars2[, contrast_1 := fcase(cyl == 4, -2, cyl \%in\% c(6, 8), 1)]
mtcars2[, contrast_2 := fcase(cyl == 4, 0, cyl == 6, 1, cyl == 8, -1)]
floodlight_for_contrasts(
data = mtcars2,
iv_name = "cyl",
dv_name = "mpg",
mod_name = "qsec",
contrasts = paste0("contrast_", 1:2),
contrasts_for_floodlight = "contrast_2")
}
}
