% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/khis_cred.R
\name{khis_cred}
\alias{khis_cred}
\title{Sets the KHIS Credentials}
\usage{
khis_cred(
  config_path = NULL,
  username = NULL,
  password = NULL,
  base_url = NULL
)
}
\arguments{
\item{config_path}{An optional parameters that contains the path to
configuration file with username and password.}

\item{username}{The KHIS username. Can be optional if \code{config_path} is
already provided}

\item{password}{The KHIS password. Can be optional if \code{config_path} is
already provided.}

\item{base_url}{The base url used for the KHIS instance. The default is NULL
which is the \url{https://hiskenya.org/api}}
}
\value{
No return value
}
\description{
Sets the KHIS Credentials
}
\details{
The credentials can be provided using a configuration file (more secure) or
providing \code{username} and \code{password} arguments. The \code{config_path} is considered
more secure since credentials will not appear in the code.
}
\examples{

# Load username and password
khis_cred(username = 'khis_username', password = 'PASSWORD')
}
\seealso{
Other credential functions: 
\code{\link{khis_cred_clear}()},
\code{\link{khis_has_cred}()},
\code{\link{khis_username}()}
}
\concept{credential functions}
