% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keys-manip.R
\name{keys-manipulate}
\alias{keys-manipulate}
\alias{remove_keys}
\alias{restore_keys}
\alias{pull_key}
\alias{rename_keys}
\title{Manipulate keys}
\usage{
remove_keys(.tbl, ..., .unkey = FALSE)

restore_keys(.tbl, ..., .remove = FALSE, .unkey = FALSE)

pull_key(.tbl, var)

rename_keys(.tbl, ...)
}
\arguments{
\item{.tbl}{Reference data frame.}

\item{...}{Variables to be used for operations defined in similar fashion as
in \code{\link[dplyr:select]{dplyr::select()}}.}

\item{.unkey}{Whether to \code{\link[=unkey]{unkey()}} \code{.tbl} in case there are no keys left.}

\item{.remove}{Whether to remove keys after restoring.}

\item{var}{Parameter for \code{\link[dplyr:pull]{dplyr::pull()}}.}
}
\description{
Functions to manipulate \link[=keys-set]{keys}.
}
\details{
\code{remove_keys()} removes keys defined with \code{...}.

\code{restore_keys()} transfers keys defined with \code{...} into \code{.tbl} and removes
them from \code{keys} if \code{.remove == TRUE}. If \code{.tbl} is grouped the following
happens:
\itemize{
\item If restored keys don't contain grouping variables then groups don't change;
\item If restored keys contain grouping variables then result will be regrouped
based on restored values. In other words restoring keys beats 'not-modifying'
grouping variables rule. It is made according to the ideology of keys: they
contain information about rows and by restoring you want it to be
available.
}

\code{pull_key()} extracts one specified column from keys with \code{\link[dplyr:pull]{dplyr::pull()}}.

\code{rename_keys()} renames columns in keys using \code{\link[dplyr:rename]{dplyr::rename()}}.
}
\examples{
df <- mtcars \%>\% dplyr::as_tibble() \%>\%
  key_by(vs, am, .exclude = TRUE)
df \%>\% remove_keys(vs)

df \%>\% remove_keys(dplyr::everything())

df \%>\% remove_keys(dplyr::everything(), .unkey = TRUE)


df \%>\% restore_keys(vs)

df \%>\% restore_keys(vs, .remove = TRUE)


df \%>\% restore_keys(dplyr::everything(), .remove = TRUE)

df \%>\% restore_keys(dplyr::everything(), .remove = TRUE, .unkey = TRUE)


# Restoring on grouped data frame
df_grouped <- df \%>\% dplyr::mutate(vs = 1) \%>\% dplyr::group_by(vs)
df_grouped \%>\% restore_keys(dplyr::everything())

# Pulling
df \%>\% pull_key(vs)

# Renaming
df \%>\% rename_keys(Vs = vs)

}
\seealso{
\link[=keys-get]{Get keys}, \link[=keys-set]{Set keys}

\link[=keyholder-scoped]{Scoped functions}
}
