% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers.advanced_activations.R
\name{AdvancedActivation}
\alias{AdvancedActivation}
\alias{LeakyReLU}
\alias{PReLU}
\alias{ELU}
\alias{ThresholdedReLU}
\title{Advanced activation layers}
\usage{
LeakyReLU(alpha = 0.3, input_shape = NULL)

PReLU(input_shape = NULL)

ELU(alpha = 1, input_shape = NULL)

ThresholdedReLU(theta = 1, input_shape = NULL)
}
\arguments{
\item{alpha}{float >= 0. Negative slope coefficient in
\link{LeakyReLU} and scale for the negative
factor in \link{ELU}.}

\item{input_shape}{only need when first layer of a model;
sets the input shape of the data}

\item{theta}{float >= 0. Threshold location of
activation in \link{ThresholdedReLU}.}
}
\description{
Advanced activation layers
}
\examples{
if(keras_available()) {
  X_train <- matrix(rnorm(100 * 10), nrow = 100)
  Y_train <- to_categorical(matrix(sample(0:2, 100, TRUE), ncol = 1), 3)
  
  mod <- Sequential()
  mod$add(Dense(units = 50, input_shape = dim(X_train)[2]))
  mod$add(LeakyReLU(alpha = 0.4))
  mod$add(Dense(units = 50))
  mod$add(ELU(alpha = 0.5))
  mod$add(Dense(units = 50))
  mod$add(ThresholdedReLU(theta = 1.1))
  mod$add(Dense(units = 3))
  mod$add(Activation("softmax"))
  keras_compile(mod,  loss = 'categorical_crossentropy', optimizer = RMSprop())
  
  keras_fit(mod, X_train, Y_train, batch_size = 32, epochs = 5, verbose = 0)
}
}
\references{
Chollet, Francois. 2015. \href{https://keras.io/}{Keras: Deep Learning library for Theano and TensorFlow}.
}
\seealso{
Other layers: \code{\link{Activation}},
  \code{\link{ActivityRegularization}},
  \code{\link{BatchNormalization}}, \code{\link{Conv}},
  \code{\link{Dense}}, \code{\link{Dropout}},
  \code{\link{Embedding}}, \code{\link{Flatten}},
  \code{\link{GaussianNoise}}, \code{\link{LayerWrapper}},
  \code{\link{LocallyConnected}}, \code{\link{Masking}},
  \code{\link{MaxPooling}}, \code{\link{Permute}},
  \code{\link{RNN}}, \code{\link{RepeatVector}},
  \code{\link{Reshape}}, \code{\link{Sequential}}
}
\author{
Taylor B. Arnold, \email{taylor.arnold@acm.org}
}
