% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers.local.R
\name{LocallyConnected}
\alias{LocallyConnected}
\alias{LocallyConnected1D}
\alias{LocallyConnected2D}
\title{Locally-connected layer}
\usage{
LocallyConnected1D(filters, kernel_size, strides = 1, padding = "valid",
  activation = NULL, use_bias = TRUE,
  kernel_initializer = "glorot_uniform", bias_initializer = "zeros",
  kernel_regularizer = NULL, bias_regularizer = NULL,
  activity_regularizer = NULL, kernel_constraint = NULL,
  bias_constraint = NULL, input_shape = NULL)

LocallyConnected2D(filters, kernel_size, strides = c(1, 1),
  padding = "valid", data_format = NULL, activation = NULL,
  use_bias = TRUE, kernel_initializer = "glorot_uniform",
  bias_initializer = "zeros", kernel_regularizer = NULL,
  bias_regularizer = NULL, activity_regularizer = NULL,
  kernel_constraint = NULL, bias_constraint = NULL, input_shape = NULL)
}
\arguments{
\item{filters}{Integer, the dimensionality of the output space
(i.e. the number output of filters in the convolution).}

\item{kernel_size}{A pair of integers specifying the dimensions of the 2D
convolution window.}

\item{strides}{A pair of integers specifying the stride length of the
convolution.}

\item{padding}{One of "valid", "causal" or "same" (case-insensitive).}

\item{activation}{Activation function to use}

\item{use_bias}{Boolean, whether the layer uses a bias vector.}

\item{kernel_initializer}{Initializer for the kernel weights matrix}

\item{bias_initializer}{Initializer for the bias vector}

\item{kernel_regularizer}{Regularizer function applied to the kernel weights matrix}

\item{bias_regularizer}{Regularizer function applied to the bias vector}

\item{activity_regularizer}{Regularizer function applied to the output of the layer (its "activation").}

\item{kernel_constraint}{Constraint function applied to the kernel matrix}

\item{bias_constraint}{Constraint function applied to the bias vector}

\item{input_shape}{only need when first layer of a model; sets the input shape
of the data}

\item{data_format}{A string, one of channels_last (default) or channels_first.
The ordering of the dimensions in the inputs.}
}
\description{
The LocallyConnected layers works similarly to the Conv layers,
except that weights are unshared, that is, a different set of
filters is applied at each different patch of the input.
}
\examples{
if (run_examples()) {
X_train <- array(rnorm(100 * 28 * 28), dim = c(100, 28, 28, 1))
Y_train <- to_categorical(matrix(sample(0:2, 100, TRUE), ncol = 1), 3)

mod <- Sequential()
mod$add(Conv2D(filters = 2, kernel_size = c(2, 2),
               input_shape = c(28, 28, 1)))
mod$add(Activation("relu"))
mod$add(MaxPooling2D(pool_size=c(2, 2)))
mod$add(LocallyConnected2D(filters = 2, kernel_size = c(2, 2)))
mod$add(Activation("relu"))
mod$add(MaxPooling2D(pool_size=c(2, 2)))
mod$add(Dropout(0.25))

mod$add(Flatten())
mod$add(Dropout(0.5))
mod$add(Dense(3, activation='softmax'))

keras_compile(mod, loss='categorical_crossentropy', optimizer=RMSprop())
keras_fit(mod, X_train, Y_train, verbose = 0)
}
}
\references{
Chollet, Francois. 2015. \href{https://keras.io/}{Keras: Deep Learning library for Theano and TensorFlow}.
}
\author{
Taylor B. Arnold, \email{taylor.arnold@acm.org}
}
