% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers-recurrent.R
\name{layer_gru}
\alias{layer_gru}
\title{Gated Recurrent Unit - Cho et al.}
\usage{
layer_gru(
  object,
  units,
  activation = "tanh",
  recurrent_activation = "hard_sigmoid",
  use_bias = TRUE,
  return_sequences = FALSE,
  return_state = FALSE,
  go_backwards = FALSE,
  stateful = FALSE,
  unroll = FALSE,
  time_major = FALSE,
  reset_after = FALSE,
  kernel_initializer = "glorot_uniform",
  recurrent_initializer = "orthogonal",
  bias_initializer = "zeros",
  kernel_regularizer = NULL,
  recurrent_regularizer = NULL,
  bias_regularizer = NULL,
  activity_regularizer = NULL,
  kernel_constraint = NULL,
  recurrent_constraint = NULL,
  bias_constraint = NULL,
  dropout = 0,
  recurrent_dropout = 0,
  input_shape = NULL,
  batch_input_shape = NULL,
  batch_size = NULL,
  dtype = NULL,
  name = NULL,
  trainable = NULL,
  weights = NULL
)
}
\arguments{
\item{object}{What to call the new \code{Layer} instance with. Typically a keras
\code{Model}, another \code{Layer}, or a \code{tf.Tensor}/\code{KerasTensor}. If \code{object} is
missing, the \code{Layer} instance is returned, otherwise, \code{layer(object)} is
returned.}

\item{units}{Positive integer, dimensionality of the output space.}

\item{activation}{Activation function to use. Default: hyperbolic tangent
(\code{tanh}). If you pass \code{NULL}, no activation is applied
(ie. "linear" activation: \code{a(x) = x}).}

\item{recurrent_activation}{Activation function to use for the recurrent
step.}

\item{use_bias}{Boolean, whether the layer uses a bias vector.}

\item{return_sequences}{Boolean. Whether to return the last output in the
output sequence, or the full sequence.}

\item{return_state}{Boolean (default FALSE). Whether to return the last state
in addition to the output.}

\item{go_backwards}{Boolean (default FALSE). If TRUE, process the input
sequence backwards and return the reversed sequence.}

\item{stateful}{Boolean (default FALSE). If TRUE, the last state for each
sample at index i in a batch will be used as initial state for the sample
of index i in the following batch.}

\item{unroll}{Boolean (default FALSE). If TRUE, the network will be unrolled,
else a symbolic loop will be used. Unrolling can speed-up a RNN, although
it tends to be more memory-intensive. Unrolling is only suitable for short
sequences.}

\item{time_major}{If True, the inputs and outputs will be in shape
\verb{[timesteps, batch, feature]}, whereas in the False case, it will be
\verb{[batch, timesteps, feature]}. Using \code{time_major = TRUE} is a bit more
efficient because it avoids transposes at the beginning and end of the RNN
calculation. However, most TensorFlow data is batch-major, so by default
this function accepts input and emits output in batch-major form.}

\item{reset_after}{GRU convention (whether to apply reset gate after or
before matrix multiplication). FALSE = "before" (default),
TRUE = "after" (CuDNN compatible).}

\item{kernel_initializer}{Initializer for the \code{kernel} weights matrix, used
for the linear transformation of the inputs.}

\item{recurrent_initializer}{Initializer for the \code{recurrent_kernel} weights
matrix, used for the linear transformation of the recurrent state.}

\item{bias_initializer}{Initializer for the bias vector.}

\item{kernel_regularizer}{Regularizer function applied to the \code{kernel}
weights matrix.}

\item{recurrent_regularizer}{Regularizer function applied to the
\code{recurrent_kernel} weights matrix.}

\item{bias_regularizer}{Regularizer function applied to the bias vector.}

\item{activity_regularizer}{Regularizer function applied to the output of the
layer (its "activation")..}

\item{kernel_constraint}{Constraint function applied to the \code{kernel} weights
matrix.}

\item{recurrent_constraint}{Constraint function applied to the
\code{recurrent_kernel} weights matrix.}

\item{bias_constraint}{Constraint function applied to the bias vector.}

\item{dropout}{Float between 0 and 1. Fraction of the units to drop for the
linear transformation of the inputs.}

\item{recurrent_dropout}{Float between 0 and 1. Fraction of the units to drop
for the linear transformation of the recurrent state.}

\item{input_shape}{Dimensionality of the input (integer) not including the
samples axis. This argument is required when using this layer as the first
layer in a model.}

\item{batch_input_shape}{Shapes, including the batch size. For instance,
\code{batch_input_shape=c(10, 32)} indicates that the expected input will be
batches of 10 32-dimensional vectors. \code{batch_input_shape=list(NULL, 32)}
indicates batches of an arbitrary number of 32-dimensional vectors.}

\item{batch_size}{Fixed batch size for layer}

\item{dtype}{The data type expected by the input, as a string (\code{float32},
\code{float64}, \code{int32}...)}

\item{name}{An optional name string for the layer. Should be unique in a
model (do not reuse the same name twice). It will be autogenerated if it
isn't provided.}

\item{trainable}{Whether the layer weights will be updated during training.}

\item{weights}{Initial weights for layer.}
}
\description{
There are two variants. The default one is based on 1406.1078v3 and
has reset gate applied to hidden state before matrix multiplication. The
other one is based on original 1406.1078v1 and has the order reversed.
}
\details{
The second variant is compatible with CuDNNGRU (GPU-only) and allows
inference on CPU. Thus it has separate biases for \code{kernel} and
\code{recurrent_kernel}. Use \code{reset_after = TRUE} and
\code{recurrent_activation = "sigmoid"}.
}
\section{Input shapes}{


3D tensor with shape \verb{(batch_size, timesteps, input_dim)},
(Optional) 2D tensors with shape \verb{(batch_size, output_dim)}.
}

\section{Output shape}{

\itemize{
\item if \code{return_state}: a list of tensors. The first tensor is
the output. The remaining tensors are the last states,
each with shape \verb{(batch_size, units)}.
\item if \code{return_sequences}: 3D tensor with shape
\verb{(batch_size, timesteps, units)}.
\item else, 2D tensor with shape \verb{(batch_size, units)}.
}
}

\section{Masking}{


This layer supports masking for input data with a variable number
of timesteps. To introduce masks to your data,
use an embedding layer with the \code{mask_zero} parameter
set to \code{TRUE}.
}

\section{Statefulness in RNNs}{


You can set RNN layers to be 'stateful', which means that the states
computed for the samples in one batch will be reused as initial states
for the samples in the next batch. This assumes a one-to-one mapping
between samples in different successive batches. For intuition behind
statefulness, there is a helpful blog post here:
\url{https://philipperemy.github.io/keras-stateful-lstm/}

To enable statefulness:
\itemize{
\item Specify \code{stateful = TRUE} in the layer constructor.
\item Specify a fixed batch size for your model. For sequential models,
pass \code{batch_input_shape = c(...)} to the first layer in your model.
For functional models with 1 or more Input layers, pass
\code{batch_shape = c(...)} to all the first layers in your model.
This is the expected shape of your inputs \emph{including the batch size}.
It should be a vector of integers, e.g. \code{c(32, 10, 100)}.
For dimensions which can vary (are not known ahead of time),
use \code{NULL} in place of an integer, e.g. \code{c(32, NULL, NULL)}.
\item Specify \code{shuffle = FALSE} when calling fit().
}

To reset the states of your model, call \code{reset_states()} on either
a specific layer, or on your entire model.
}

\section{Initial State of RNNs}{


You can specify the initial state of RNN layers symbolically by calling
them with the keyword argument \code{initial_state}. The value of
\code{initial_state} should be a tensor or list of tensors representing
the initial state of the RNN layer.

You can specify the initial state of RNN layers numerically by
calling \code{reset_states} with the keyword argument \code{states}. The value of
\code{states} should be a numpy array or list of numpy arrays representing
the initial state of the RNN layer.
}

\section{References}{

\itemize{
\item \href{https://arxiv.org/abs/1406.1078}{Learning Phrase Representations using RNN Encoder-Decoder for Statistical Machine Translation}
\item \href{https://arxiv.org/abs/1409.1259}{On the Properties of Neural Machine Translation: Encoder-Decoder Approaches}
\item \href{https://arxiv.org/abs/1412.3555v1}{Empirical Evaluation of Gated Recurrent Neural Networks on Sequence Modeling}
\item \href{https://arxiv.org/abs/1512.05287}{A Theoretically Grounded Application of Dropout in Recurrent Neural Networks}
}
}

\seealso{
Other recurrent layers: 
\code{\link{layer_cudnn_gru}()},
\code{\link{layer_cudnn_lstm}()},
\code{\link{layer_lstm}()},
\code{\link{layer_simple_rnn}()}
}
\concept{recurrent layers}
