% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers-core.R
\name{layer_flatten}
\alias{layer_flatten}
\title{Flattens an input}
\usage{
layer_flatten(
  object,
  data_format = NULL,
  input_shape = NULL,
  dtype = NULL,
  name = NULL,
  trainable = NULL,
  weights = NULL
)
}
\arguments{
\item{object}{What to call the new \code{Layer} instance with. Typically a keras
\code{Model}, another \code{Layer}, or a \code{tf.Tensor}/\code{KerasTensor}. If \code{object} is
missing, the \code{Layer} instance is returned, otherwise, \code{layer(object)} is
returned.}

\item{data_format}{A string. one of \code{channels_last} (default) or
\code{channels_first}. The ordering of the dimensions in the inputs. The purpose
of this argument is to preserve weight ordering when switching a model from
one data format to another. \code{channels_last} corresponds to inputs with
shape \verb{(batch, ..., channels)} while \code{channels_first} corresponds to inputs
with shape \verb{(batch, channels, ...)}. It defaults to the \code{image_data_format}
value found in your Keras config file at \verb{~/.keras/keras.json}. If you
never set it, then it will be "channels_last".}

\item{input_shape}{Input shape (list of integers, does not include the
samples axis) which is required when using this layer as the first layer in
a model.}

\item{dtype}{The data type expected by the input, as a string (\code{float32},
\code{float64}, \code{int32}...)}

\item{name}{An optional name string for the layer. Should be unique in a
model (do not reuse the same name twice). It will be autogenerated if it
isn't provided.}

\item{trainable}{Whether the layer weights will be updated during training.}

\item{weights}{Initial weights for layer.}
}
\description{
Flatten a given input, does not affect the batch size.
}
\seealso{
Other core layers: 
\code{\link{layer_activation}()},
\code{\link{layer_activity_regularization}()},
\code{\link{layer_attention}()},
\code{\link{layer_dense_features}()},
\code{\link{layer_dense}()},
\code{\link{layer_dropout}()},
\code{\link{layer_input}()},
\code{\link{layer_lambda}()},
\code{\link{layer_masking}()},
\code{\link{layer_permute}()},
\code{\link{layer_repeat_vector}()},
\code{\link{layer_reshape}()}
}
\concept{core layers}
