% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{text_hashing_trick}
\alias{text_hashing_trick}
\title{Converts a text to a sequence of indexes in a fixed-size hashing space.}
\usage{
text_hashing_trick(text, n, hash_function = NULL,
  filters = "!\\"#$\%&()*+,-./:;<=>?@[\\\\]^_`{|}~\\t\\n", lower = TRUE,
  split = " ")
}
\arguments{
\item{text}{Input text (string).}

\item{n}{Dimension of the hashing space.}

\item{hash_function}{if \code{NULL} uses python \code{hash} function, can be 'md5' or
any function that takes in input a string and returns a int. Note that
\code{hash} is not a stable hashing function, so it is not consistent across
different runs, while 'md5' is a stable hashing function.}

\item{filters}{Sequence of characters to filter out.}

\item{lower}{Whether to convert the input to lowercase.}

\item{split}{Sentence split marker (string).}
}
\value{
A list of integer word indices (unicity non-guaranteed).
}
\description{
Converts a text to a sequence of indexes in a fixed-size hashing space.
}
\details{
Two or more words may be assigned to the same index, due to possible
collisions by the hashing function.
}
\seealso{
Other text preprocessing: \code{\link{make_sampling_table}},
  \code{\link{pad_sequences}}, \code{\link{skipgrams}},
  \code{\link{text_one_hot}},
  \code{\link{text_to_word_sequence}}
}
