% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/builtin_bandwidths.R
\name{bandwidths}
\alias{bandwidths}
\title{Bandwidth Selectors}
\arguments{
\item{x}{The input data.}

\item{kernel_str}{A string specifying the kernel, e.g. "gaussian."}

\item{start_str}{A string specifying the parametric start, e.g. "normal".}

\item{support}{The domain of definition for the kernel. (-Inf, Inf) for
symmetric kernels.}
}
\description{
The available options for bandwidth selectors, passed as the \code{bw}
argument to \code{kdensity}.
}
\details{
The bandwidth functions are not exported. They are members of the
environment \code{bw_environments}, and can be accessed by
\code{kdensity:::bw_environments}.
}
\section{Bandwidth selectors}{

   \code{"nrd0", "nrd", "bcv", "SJ"}: Bandwidth selectors from \code{stats}.
   They are documented in \code{\link[stats]{bandwidth} stats:bandwidth}.
   "nrd0" is the standard bandwidth selector for symmetric kernels with
   constant parametric starts.

   \code{"ucv"}: Unbiased cross validation. The standard option for
   asymmetric kernels.

   \code{"RHE"}: Selector for parametric starts with a symmetric kernel,
   based on a reference rule with Hermite polynomials.
   Described in Hjort & Glad (1995). The default method in \code{kdensity} when a parametric
   start is supplied and the kernel is symmetric.

   \code{"JH"}: Selector for the Gaussian copula kernel, based on
   normal reference rule. Described in Jones & Henderson. The default method when
   the \code{gcopula} kernel is used in \code{kdensity}.
}

\section{Structure}{

   The bandwidth selector is a function of four arguments: The data
   \code{x}, a kernel string \code{kernel}, a start string \code{start},
   and a support vector \code{support}. To obtain the functions associated
   with these strings, use \code{get_kernel} and \code{get_start}. The
   function should return a double.
}

\examples{
   ## Not a serious bandwidth function.
   silly_width = function(x, kernel = NULL, start = NULL, support = NULL) {
     rexp(1)
   }
   kdensity(mtcars$mpg, start = "gumbel", bw = silly_width)
}
\references{
Jones, M. C., and D. A. Henderson. "Kernel-type density estimation on the unit interval." Biometrika 94.4 (2007): 977-984.
Hjort, Nils Lid, and Ingrid K. Glad. "Nonparametric density estimation with a parametric start." The Annals of Statistics (1995): 882-904.
}
\seealso{
\code{\link{kdensity}}, \code{\link[stats]{bandwidth}} for the
   bandwidth selectors of \code{\link[stats]{density}}. In addition,
   \code{\link{kernels}}; \code{\link{parametric_starts}}
}
