% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel.r
\docType{methods}
\name{rewire_network}
\alias{rewire_network}
\alias{rewire_network,pathway-method}
\title{Rewires interactions in a \code{\link{pathway}}, which go through a gene not 
represented by any SNPs in the considered \code{\link{GWASdata}} dataset.}
\usage{
\S4method{rewire_network}{pathway}(object, x)
}
\arguments{
\item{object}{\code{\link{pathway}} object which's network \code{matrix} will be rewired}

\item{x}{A \code{vector} of gene names, indicating which genes are not represented
by SNPs in the considered \code{\link{GWASdata}} object and will be removed}
}
\value{
A \code{\link{pathway}} object including the rewired network \code{matrix}
}
\description{
Rewires interactions in a \code{\link{pathway}}, which go through a gene not 
represented by any SNPs in the considered \code{\link{GWASdata}} dataset.
}
\examples{
\dontrun{
data(hsa04020)
summary(hsa04020)
hsa04020_rewired <- rewire_network(hsa04020, x=c('ADCY3', 'CALML3','GNAQ'))
summary(hsa04020_rewired)
}
}
\author{
Juliane Manitz, Stefanie Friedrichs
}
