% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/srce.R
\name{source}
\alias{source}
\alias{dcsn}
\alias{jstf}
\alias{asrt}
\alias{srce}
\alias{decide}
\alias{decision}
\alias{assert}
\alias{justify}
\alias{c.justifierElement}
\title{Programmatically constructing justifier elements}
\usage{
source(label, description = NULL, type = NULL, id = NULL, xdoi = NULL, ...)

assert(label, description = "", type = NULL, id = NULL, source = NULL, ...)

justify(label, description = "", type = NULL, id = NULL, assertion = NULL, ...)

decide(
  label,
  description = NULL,
  type = NULL,
  id = NULL,
  alternatives = NULL,
  justification = NULL,
  ...
)

\method{c}{justifierElement}(...)
}
\arguments{
\item{label}{A human-readable label for the \code{decision}, \code{justification},
\code{assertion}, or \code{source}. Labels are brief summaries of the core of the
decision, justification, assertion, or source. More details, background
information, context, and other comments can be placed in the description.}

\item{description}{A human-readable description. This can be used to
elaborate on the label. Note that the label should be reader-friendly and
self-contained; but because they also have to be as short as possible,
descriptions can be used to provide definitions, context, background
information, or add any other metadata or comments.}

\item{type}{Types are used when working with a framework. Frameworks define
type identifiers, consisting of letters, digits, and underscores. By
specifying these identifiers the type of a decision, justification,
assertion, or source. Source types can be, for example, types of documents
or other data providers, such as "empirical evidence', 'expert consensus',
'personal opinion', or 'that one meeting that we had in May'. Assertion
types can be, for example, data types or types of facts, such as 'number',
'prevalence', 'causal relationship', or 'contact information'.
Justification types can be, for example, types of reasoning or logical
expressions, such as 'deduction', 'induction', or 'intersection'. Decision
types are the most framework-specific, heavily depend on the specific
context of the decision, and are used by frameworks to organise the
decisions in a project. Examples of decision types are the decision to
recruit a certain number of participants in a scientific study; the decision
to target a certain belief in a behavior change intervention; the decision
to merge two codes in a qualitative study; the decision to hire a staff
member; or the decision to make a certain purchase.}

\item{id}{The identifier (randomly generated if omitted).}

\item{xdoi}{For \code{source}s, XDOI identifier (a DOI, or, if that does not
exist, ISBN or other unique identifier of the source).}

\item{...}{Additional fields and values to store in the element.}

\item{source}{In assertions, the source (or sources) that the assertion
is based on can be specified using \code{srce()}.}

\item{assertion}{In justifications, the assertion (or assertions) that
the justification is based on can be specified using \code{asrt()}.}

\item{alternatives}{The alternatives that were considered in a decision.}

\item{justification}{In decisions, the justification (or justifications)
that the decision is based on can be specified using \code{jstf()}.}
}
\value{
The generated object.
}
\description{
These functions can be used to programmatically construct justifications.
}
\examples{
### Programmatically create a partial justification object
justifierAssertion <-
  justifier::assert(
    "This is an assertion",
    source = c(
      justifier::source('This is a first source'),
      justifier::source('This is a second source')));

### Programmatically create a justification with two assertions
### but without sources
justifierJustification <-
  justifier::justify(
    "Icecream will make me feel less fit",
    assertion = c(
      justifier::assert('Icecream is rich in energy'),
      justifier::assert('Consuming high-energy foods makes me feel less fit')
    ),
    weight = -.5
  );

### Show it
justifierJustification;

### Programmatically create a simple decision
simpleDecision <-
  justifier::decide(
    "decision",
    justification = justifier::jstf(
      "justification",
      assertion = justifierAssertion
    )
  );

### Programmatically create a justification object for a full decision
fullJustifierObject <-
  justifier::decide(
    "I decide to go get an icecream",
    justification = c(
      justifier::justify(
        "Having an icecream now would make me happy",
        assertion = c(
          justifier::assert(
            "Decreasing hunger increases happiness",
            source = justifier::source(
              "My past experiences"
            )
          ),
          justifier::assert(
            "I feel hungry",
            source = justifier::source(
              "Bodily sensations"
            )
          )
        ),
        weight = 1
      ),
      justifierJustification,
      justifier::justify(
        "I can afford to buy an icecream.",
        assertion = c(
          justifier::assert(
            "My bank account balance is over 300 euro.",
            source = justifier::source(
              "My bank app"
            )
          ),
          justifier::assert(
            "I need to keep at least 100 euro in my bank account.",
            source = justifier::source(
              "Parental advice"
            )
          )
        ),
        weight = .3
      )
    )
  );

### Show the full object
fullJustifierObject;

### Combine both into a list of decisions
twoDecisions <-
  c(simpleDecision,
    fullJustifierObject);

### Show the combination
twoDecisions;

}
